from BaseAction import BaseAction
from Nao import NaoMotionList

class Motion(BaseAction):
    def __init__(self, motionName = "", motion = None, blocking = False):
        super(Motion, self).__init__()
        self._motionName = str(motionName)
        self._motion = motion
        self._blocking = blocking
        if self._motion is None:
            self._motion = NaoMotionList.find(self._motionName)
        else:
            self._motionName = self._motion.name()
        #END if
    #END __init__()

    def execute(self, nao):
        nao.motion(self._motion, not self._blocking)
    #END execute()

    def actionToString(self):
        return "Motion"
    #END actionToString()

    def paramToString(self):
        return self._motionName
    #END paramToString()
#END class