from BaseAction import BaseAction

class Speech(BaseAction):
    def __init__(self, text, speed = 90, shaping = 100, blocking = True):
        super(Speech, self).__init__()
        self._text = str(text)
        self._speed = min(200, max(50, int(speed)))
        self._shaping = min(150, max(50, int(shaping)))
        self._blocking = blocking
    #END __init__()

    def execute(self, nao):
        nao.say(self.paramToString(), not self._blocking)
    #END execute()

    def actionToString(self):
        return "Speech"
    #END actionToString()

    def paramToString(self):
        return "\\RSPD=" + str(self._speed) + "\\ \\VCT=" + str(self._shaping) + "\\ " + self._text + " \\RST\\"
    #END paramToString()

    @staticmethod
    def markSpeech(speed = 90, shaping = 100):
        # ending mark + speed + shaping
        return " \\RST\\ \\RSPD=" + str(speed) + "\\ \\VCT=" + str(shaping) + "\\ "
    #END markSpeech()
#END class