class Camera:
    Top, \
    Bottom, \
    Both \
 = range(3)
#END class


class CameraResolution:
    # In order of resolution
    # 160 * 120px
    # 320 * 240px
    # 640 * 480px
    # 1280 * 960px
    QQVGA, \
    QVGA, \
    VGA, \
    FOUR_VGA \
 = range(4)
#END class


class CameraColorSpace:
    # Parameter        ID Value    nChannels    Description
    kYuvColorSpace     = 0       #     1        Buffer only contains the Y (luma component) equivalent to one unsigned char
    kyUvColorSpace     = 1       #     1        Buffer only contains the U (Chrominance component) equivalent to one unsigned char
    kyuVColorSpace     = 2       #     1        Buffer only contains the V (Chrominance component) equivalent to one unsigned char
    kRgbColorSpace     = 3       #     1        Buffer only contains the R (Red component) equivalent to one unsigned char
    krGbColorSpace     = 4       #     1        Buffer only contains the G (Green component) equivalent to one unsigned char
    krgBColorSpace     = 5       #     1        Buffer only contains the B (Blue component) equivalent to one unsigned char
    kHsyColorSpace     = 6       #     1        Buffer only contains the H (Hue component) equivalent to one unsigned char
    khSyColorSpace     = 7       #     1        Buffer only contains the S (Saturation component) equivalent to one unsigned char
    khsYColorSpace     = 8       #     1        Buffer only contains the Y (Brithness component) equivalent to one unsigned char
    kYUV422ColorSpace  = 9       #     3        Native format, 0xY'Y'VVYYUU equivalent to four unsigned char for two pixels. With Y luma for pixel n, Y' luma for pixel n+1, and U and V are the average chrominance value of both pixels.
    kYUVColorSpace     = 10      #     3        Buffer contains triplet on the format 0xVVUUYY, equivalent to three unsigned char
    kRGBColorSpace     = 11      #     3        Buffer contains triplet on the format 0xBBGGRR, equivalent to three unsigned char
    kHSYColorSpace     = 12      #     3        Buffer contains triplet on the format 0xYYSSHH, equivalent to three unsigned char
    kBGRColorSpace     = 13      #     3        Buffer contains triplet on the format 0xRRGGBB, equivalent to three unsigned char
    kYYCbCrColorSpace  = 14      #     3        TIFF format, four unsigned chararacters for two pixels.
    kH2RGBColorSpace   = 15      #     3        H from "HSY to RGB" in fake colors.
    kHSMixedColorSpace = 16      #     3        HS and (H+S)/2.
#END class


class Direction:
    Neutral, \
    Up, \
    Down, \
    Left, \
    Right \
 = range(5)
#END class


class LEDNames:
    All = "AllLeds"
    Brain = "BrainLeds"
    Ears = "EarLeds"
    LeftEar = "LeftEarLeds"
    RightEar = "RightEarLeds"
    Face = "FaceLeds"
    FaceLeft = "LeftFaceLeds"
    FaceRight = "RightFaceLeds"
    Chest = "ChestLeds"
    Feet = "FeetLeds"
#END class


#DEFAULT_IP = "127.0.0.1"
DEFAULT_IP = '130.179.30.44'
#DEFAULT_IP = '140.193.228.26'
DEFAULT_PORT = 9559
VIDEO_COLORSPACE = CameraColorSpace.kRGBColorSpace
VIDEO_QUALITY = CameraResolution.VGA
VIDEO_SUBSCRIBE_NAME = "NaoVideo"
