from NaoMotion import NaoMotion

class NaoMotionList():
    _motions = list()

    @staticmethod
    def initialize():
        NaoMotionList._motions.append(Default())
        NaoMotionList._motions.append(Idle0())
        NaoMotionList._motions.append(Idle1())
        NaoMotionList._motions.append(Idle2())
        NaoMotionList._motions.append(Idle3())
        NaoMotionList._motions.append(Idle4())
        NaoMotionList._motions.append(Idle5())
        NaoMotionList._motions.append(Idle6())
        NaoMotionList._motions.append(HeadHmove())
        NaoMotionList._motions.append(Disagree())
        NaoMotionList._motions.append(DisagreeLeft())
        NaoMotionList._motions.append(DisagreeRight())
        NaoMotionList._motions.append(DontKnow())
        NaoMotionList._motions.append(DontKnowLeft())
        NaoMotionList._motions.append(DontKnowRight())
        NaoMotionList._motions.append(Wait())
        NaoMotionList._motions.append(WaveHandLeft())
        NaoMotionList._motions.append(WaveHandRight())
        NaoMotionList._motions.append(ForgetItLeft())
        NaoMotionList._motions.append(ForgetItRight())
        NaoMotionList._motions.append(OhYesLeft())
        NaoMotionList._motions.append(OhYesRight())
        NaoMotionList._motions.append(PalmUp())
        NaoMotionList._motions.append(PalmUpLeft())
        NaoMotionList._motions.append(PalmUpRight())
        NaoMotionList._motions.append(PointMyself())
        NaoMotionList._motions.append(PointMyselfLeft())
        NaoMotionList._motions.append(PointMyselfRight())
        NaoMotionList._motions.append(PointYou())
        NaoMotionList._motions.append(PointYouLeft())
        NaoMotionList._motions.append(PointYouRight())
        NaoMotionList._motions.append(ChinHoldLeft())
        NaoMotionList._motions.append(ChinHoldRight())
        NaoMotionList._motions.append(Whisper())
        NaoMotionList._motions.append(WhisperLeft())
        NaoMotionList._motions.append(WhisperRight())
        NaoMotionList._motions.append(Nod1())
    #END initialize()

    @staticmethod
    def destroy():
        NaoMotionList._motions = list()
    #END destroy()

    @staticmethod
    def find(name):
        for motion in NaoMotionList._motions:
            if motion.name() == name:
                return motion
            #END if
        #END for
        return None
    #END find()

    @staticmethod
    def get(index):
        return NaoMotionList._motions[index]
    #END get()

    @staticmethod
    def length():
        return len(NaoMotionList._motions)
    #END length()
#END class

def Default():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([0.50000, 1.00000])
    keys.append([[0.92343, [3, -0.16667, 0.00000], [3, 0.16667, 0.00000]], [0.92343, [3, -0.16667, 0.00000], [3, 0.16667, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("LHand")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("RHand")
    times.append([ 0.50000, 1.00000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]]])

    motion = NaoMotion("Default")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Idle0():
    names = list()
    times = list()
    keys = list()

    names.append("LHand")
    times.append([ 0.50000, 3.50000, 6.00000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.50000, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.50000, 0.00000], [ 3, 0.16667, 0.00000]]])

    names.append("RHand")
    times.append([ 0.50000, 3.50000, 6.00000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Idle0")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Idle1():
    names = list()
    times = list()
    keys = list()

    names.append("LHand")
    times.append([ 0.50000, 3.50000, 6.00000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.50000, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.50000, 0.00000], [ 3, 0.16667, 0.00000]]])

    motion = NaoMotion("Idle1")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Idle2():
    names = list()
    times = list()
    keys = list()

    names.append("RHand")
    times.append([ 0.50000, 3.50000, 6.00000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Idle2")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Idle3():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87587, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ 0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.89581, [ 3, -0.16667, -0.00869], [ 3, 0.16667, 0.00869]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26687, [ 3, -0.16667, -0.02148], [ 3, 0.16667, 0.02148]], [ 0.39113, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.37272, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38499, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.51853, [ 3, -0.16667, 0.02582], [ 3, 0.16667, -0.02582]], [ -0.59523, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55382, [ 3, -0.16667, -0.02071], [ 3, 0.16667, 0.02071]], [ -0.47098, [ 3, -0.16667, -0.01892], [ 3, 0.16667, 0.01892]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29619, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.39283, [ 3, -0.16667, 0.04140], [ 3, 0.16667, -0.04140]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36965, [ 3, -0.16667, -0.01534], [ 3, 0.16667, 0.01534]], [ 0.38499, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.34971, [ 3, -0.16667, 0.01534], [ 3, 0.16667, -0.01534]], [ 0.29295, [ 3, -0.16667, 0.01074], [ 3, 0.16667, -0.01074]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87442, [ 3, -0.16667, 0.00614], [ 3, 0.16667, -0.00614]], [ 0.86829, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ 0.86675, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86982, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.31298, [ 3, -0.16667, 0.02429], [ 3, 0.16667, -0.02429]], [ -0.42036, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.39735, [ 3, -0.16667, -0.00716], [ 3, 0.16667, 0.00716]], [ -0.37741, [ 3, -0.16667, -0.01994], [ 3, 0.16667, 0.01994]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.52305, [ 3, -0.16667, -0.00716], [ 3, 0.16667, 0.00716]], [ 0.55066, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.47857, [ 3, -0.16667, 0.02096], [ 3, 0.16667, -0.02096]], [ 0.42488, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28400, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28400, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.42820, [ 3, -0.16667, -0.03784], [ 3, 0.16667, 0.03784]], [ 1.51103, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.37894, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -0.37741, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.34673, [ 3, -0.16667, -0.02966], [ 3, 0.16667, 0.02966]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Idle3")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Idle4():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98632, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97558, [ 3, -0.16667, 0.00358], [ 3, 0.16667, -0.00358]], [ 0.96638, [ 3, -0.16667, 0.00869], [ 3, 0.16667, -0.00869]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26687, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22699, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22699, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.84988, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.78238, [ 3, -0.16667, -0.03426], [ 3, 0.16667, 0.03426]], [ -0.64432, [ 3, -0.16667, -0.04346], [ 3, 0.16667, 0.04346]], [ -0.52160, [ 3, -0.16667, -0.03400], [ 3, 0.16667, 0.03400]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29005, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27156, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.06447, [ 3, -0.16667, -0.06647], [ 3, 0.16667, 0.06647]], [ 0.12728, [ 3, -0.16667, -0.05574], [ 3, 0.16667, 0.05574]], [ 0.26994, [ 3, -0.16667, -0.01227], [ 3, 0.16667, 0.01227]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, -0.00767], [ 3, 0.16667, 0.00767]], [ 0.99714, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 1.00941, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.00328, [ 3, -0.16667, 0.00614], [ 3, 0.16667, -0.00614]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.29457, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26849, [ 3, -0.16667, -0.00639], [ 3, 0.16667, 0.00639]], [ -0.25622, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25929, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.82065, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.79764, [ 3, -0.16667, 0.01304], [ 3, 0.16667, -0.01304]], [ 0.74241, [ 3, -0.16667, 0.02352], [ 3, 0.16667, -0.02352]], [ 0.65651, [ 3, -0.16667, 0.03912], [ 3, 0.16667, -0.03912]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29014, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29014, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29474, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29474, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.02604, [ 3, -0.16667, 0.07465], [ 3, 0.16667, -0.07465]], [ -0.19333, [ 3, -0.16667, 0.05701], [ 3, 0.16667, -0.05701]], [ -0.31605, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Idle4")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def HeadHmove():
    names = list()
    times = list()
    keys = list()
    
    names.append("HeadYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000])
    keys.append([ -0.04606, -0.04606, -0.01538, 0.07819, 0.07973, -0.00925, -0.09362, -0.17032, -0.24702, -0.32525, -0.26849, -0.07214, -0.00618, -0.00618, -0.00618])
    
    names.append("HeadPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000])
    keys.append([ -0.01845, -0.01845, -0.01845, -0.01845, -0.01845, -0.01845, -0.01692, -0.01845, -0.01845, -0.01845, -0.01845, -0.01845, -0.01845, -0.01845, -0.01845])

    motion = NaoMotion("HeadHmove")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion


def Idle5():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98632, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97558, [ 3, -0.16667, 0.00358], [ 3, 0.16667, -0.00358]], [ 0.96638, [ 3, -0.16667, 0.00869], [ 3, 0.16667, -0.00869]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26687, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22699, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22699, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.84988, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.78238, [ 3, -0.16667, -0.03426], [ 3, 0.16667, 0.03426]], [ -0.64432, [ 3, -0.16667, -0.04346], [ 3, 0.16667, 0.04346]], [ -0.52160, [ 3, -0.16667, -0.03400], [ 3, 0.16667, 0.03400]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29005, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27156, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.06447, [ 3, -0.16667, -0.06647], [ 3, 0.16667, 0.06647]], [ 0.12728, [ 3, -0.16667, -0.05574], [ 3, 0.16667, 0.05574]], [ 0.26994, [ 3, -0.16667, -0.01227], [ 3, 0.16667, 0.01227]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Idle5")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Idle6():
    names = list()
    times = list()
    keys = list()

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98632, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97558, [ 3, -0.16667, 0.00358], [ 3, 0.16667, -0.00358]], [ 0.96638, [ 3, -0.16667, 0.00869], [ 3, 0.16667, -0.00869]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26687, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22699, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22699, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84988, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.78238, [ 3, -0.16667, 0.03426], [ 3, 0.16667, -0.03426]], [ 0.64432, [ 3, -0.16667, 0.04346], [ 3, 0.16667, -0.04346]], [ 0.52160, [ 3, -0.16667, 0.03400], [ 3, 0.16667, -0.03400]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29005, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000])
    keys.append([ [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27156, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.06447, [ 3, -0.16667, 0.06647], [ 3, 0.16667, -0.06647]], [ -0.12728, [ 3, -0.16667, 0.05574], [ 3, 0.16667, -0.05574]], [ -0.26994, [ 3, -0.16667, 0.01227], [ 3, 0.16667, -0.01227]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Idle6")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Disagree():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92649, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92649, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.72401, [ 3, -0.16667, 0.07926], [ 3, 0.16667, -0.07926]], [ 0.45095, [ 3, -0.16667, 0.03835], [ 3, 0.16667, -0.03835]], [ 0.41260, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.40493, [ 3, -0.16667, 0.00435], [ 3, 0.16667, -0.00435]], [ 0.38653, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.41260, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.40493, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.52152, [ 3, -0.16667, -0.08642], [ 3, 0.16667, 0.08642]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25153, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25307, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21012, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21318, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19938, [ 3, -0.16667, 0.00435], [ 3, 0.16667, -0.00435]], [ 0.18711, [ 3, -0.16667, 0.00256], [ 3, 0.16667, -0.00256]], [ 0.18404, [ 3, -0.16667, 0.00205], [ 3, 0.16667, -0.00205]], [ 0.17483, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.42803, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.42956, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.67500, [ 3, -0.16667, 0.08309], [ 3, 0.16667, -0.08309]], [ -0.92811, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.90050, [ 3, -0.16667, -0.02761], [ 3, 0.16667, 0.02761]], [ -0.55688, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.06771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.07844, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.84528, [ 3, -0.16667, -0.10636], [ 3, 0.16667, 0.10636]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30693, [ 3, -0.16667, 0.00358], [ 3, 0.16667, -0.00358]], [ -1.31920, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.32073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32687, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32380, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31766, [ 3, -0.16667, -0.00588], [ 3, 0.16667, 0.00588]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32517, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32517, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.57367, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.57367, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.74241, [ 3, -0.16667, -0.06315], [ 3, 0.16667, 0.06315]], [ 0.95257, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95257, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.08296, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.08450, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.08450, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92649, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92649, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.72401, [ 3, -0.16667, 0.07926], [ 3, 0.16667, -0.07926]], [ 0.45095, [ 3, -0.16667, 0.03835], [ 3, 0.16667, -0.03835]], [ 0.41260, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.40493, [ 3, -0.16667, 0.00435], [ 3, 0.16667, -0.00435]], [ 0.38653, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.41260, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.40493, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.52152, [ 3, -0.16667, -0.09103], [ 3, 0.16667, 0.09103]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25153, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25307, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21012, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21318, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19938, [ 3, -0.16667, -0.00435], [ 3, 0.16667, 0.00435]], [ -0.18711, [ 3, -0.16667, -0.00256], [ 3, 0.16667, 0.00256]], [ -0.18404, [ 3, -0.16667, -0.00205], [ 3, 0.16667, 0.00205]], [ -0.17483, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.42803, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.42956, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.67500, [ 3, -0.16667, -0.08309], [ 3, 0.16667, 0.08309]], [ 0.92811, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.90050, [ 3, -0.16667, 0.02761], [ 3, 0.16667, -0.02761]], [ 0.55688, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.06771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.07844, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84528, [ 3, -0.16667, 0.09512], [ 3, 0.16667, -0.09512]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30693, [ 3, -0.16667, -0.00358], [ 3, 0.16667, 0.00358]], [ 1.31920, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.32073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32687, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32380, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31766, [ 3, -0.16667, 0.00305], [ 3, 0.16667, -0.00305]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.32517, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.32517, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.57367, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.57367, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.74241, [ 3, -0.16667, 0.06315], [ 3, 0.16667, -0.06315]], [ -0.95257, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.95257, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.08296, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.08450, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.08450, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Disagree")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def DisagreeLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92649, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92649, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.72401, [ 3, -0.16667, 0.07926], [ 3, 0.16667, -0.07926]], [ 0.45095, [ 3, -0.16667, 0.03835], [ 3, 0.16667, -0.03835]], [ 0.41260, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.40493, [ 3, -0.16667, 0.00435], [ 3, 0.16667, -0.00435]], [ 0.38653, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.41260, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.40493, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.52152, [ 3, -0.16667, -0.08642], [ 3, 0.16667, 0.08642]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25153, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25307, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21012, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21318, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19938, [ 3, -0.16667, 0.00435], [ 3, 0.16667, -0.00435]], [ 0.18711, [ 3, -0.16667, 0.00256], [ 3, 0.16667, -0.00256]], [ 0.18404, [ 3, -0.16667, 0.00205], [ 3, 0.16667, -0.00205]], [ 0.17483, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.42803, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.42956, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.67500, [ 3, -0.16667, 0.08309], [ 3, 0.16667, -0.08309]], [ -0.92811, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.90050, [ 3, -0.16667, -0.02761], [ 3, 0.16667, 0.02761]], [ -0.55688, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.06771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.07844, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.84528, [ 3, -0.16667, -0.10636], [ 3, 0.16667, 0.10636]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30693, [ 3, -0.16667, 0.00358], [ 3, 0.16667, -0.00358]], [ -1.31920, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.32073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32687, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32380, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31766, [ 3, -0.16667, -0.00588], [ 3, 0.16667, 0.00588]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32517, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32517, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.57367, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.57367, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.74241, [ 3, -0.16667, -0.06315], [ 3, 0.16667, 0.06315]], [ 0.95257, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95257, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.08296, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.08450, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.08450, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94959, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94959, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95879, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26542, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.25622, [ 3, -0.16667, -0.00358], [ 3, 0.16667, 0.00358]], [ -0.24395, [ 3, -0.16667, -0.00256], [ 3, 0.16667, 0.00256]], [ -0.24088, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.23781, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.23628, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.23321, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.23168, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.13810, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19793, [ 3, -0.16667, 0.02275], [ 3, 0.16667, -0.02275]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.49697, [ 3, -0.16667, -0.02889], [ 3, 0.16667, 0.02889]], [ 0.64117, [ 3, -0.16667, -0.03426], [ 3, 0.16667, 0.03426]], [ 0.70253, [ 3, -0.16667, -0.02480], [ 3, 0.16667, 0.02480]], [ 0.78997, [ 3, -0.16667, -0.02506], [ 3, 0.16667, 0.02506]], [ 0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86053, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.63810, [ 3, -0.16667, 0.05880], [ 3, 0.16667, -0.05880]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30854, [ 3, -0.16667, -0.00179], [ 3, 0.16667, 0.00179]], [ 1.31621, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31621, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31621, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.35150, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.35150, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.35610, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.35610, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.35763, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33309, [ 3, -0.16667, 0.00869], [ 3, 0.16667, -0.00869]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46484, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46331, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.43263, [ 3, -0.16667, -0.01994], [ 3, 0.16667, 0.01994]], [ -0.34366, [ 3, -0.16667, -0.03375], [ 3, 0.16667, 0.03375]], [ -0.23014, [ 3, -0.16667, -0.02991], [ 3, 0.16667, 0.02991]], [ -0.16418, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.18412, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.18412, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.17185, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.44644, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("DisagreeLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def DisagreeRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.94959, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94959, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94805, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95879, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.26542, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25622, [ 3, -0.16667, 0.00358], [ 3, 0.16667, -0.00358]], [ 0.24395, [ 3, -0.16667, 0.00256], [ 3, 0.16667, -0.00256]], [ 0.24088, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.23781, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.23628, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.23321, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.23168, [ 3, -0.16667, 0.00154], [ 3, 0.16667, -0.00154]], [ 0.13810, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19793, [ 3, -0.16667, -0.02275], [ 3, 0.16667, 0.02275]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.49697, [ 3, -0.16667, 0.02889], [ 3, 0.16667, -0.02889]], [ -0.64117, [ 3, -0.16667, 0.03426], [ 3, 0.16667, -0.03426]], [ -0.70253, [ 3, -0.16667, 0.02480], [ 3, 0.16667, -0.02480]], [ -0.78997, [ 3, -0.16667, 0.02506], [ 3, 0.16667, -0.02506]], [ -0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.86053, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.63810, [ 3, -0.16667, -0.05880], [ 3, 0.16667, 0.05880]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31621, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31621, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31621, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.35150, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.35150, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.35610, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.35610, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.35763, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33309, [ 3, -0.16667, -0.00869], [ 3, 0.16667, 0.00869]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.46484, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46331, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.43263, [ 3, -0.16667, 0.01994], [ 3, 0.16667, -0.01994]], [ 0.34366, [ 3, -0.16667, 0.03375], [ 3, 0.16667, -0.03375]], [ 0.23014, [ 3, -0.16667, 0.02991], [ 3, 0.16667, -0.02991]], [ 0.16418, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.18412, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.18412, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.17185, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.44644, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.92649, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92649, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.72401, [ 3, -0.16667, 0.07926], [ 3, 0.16667, -0.07926]], [ 0.45095, [ 3, -0.16667, 0.03835], [ 3, 0.16667, -0.03835]], [ 0.41260, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.40493, [ 3, -0.16667, 0.00435], [ 3, 0.16667, -0.00435]], [ 0.38653, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.41260, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.40493, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.52152, [ 3, -0.16667, -0.08642], [ 3, 0.16667, 0.08642]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25153, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25307, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21012, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21318, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19938, [ 3, -0.16667, -0.00435], [ 3, 0.16667, 0.00435]], [ -0.18711, [ 3, -0.16667, -0.00256], [ 3, 0.16667, 0.00256]], [ -0.18404, [ 3, -0.16667, -0.00205], [ 3, 0.16667, 0.00205]], [ -0.17483, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.42803, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.42956, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.67500, [ 3, -0.16667, -0.08309], [ 3, 0.16667, 0.08309]], [ 0.92811, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.90050, [ 3, -0.16667, 0.02761], [ 3, 0.16667, -0.02761]], [ 0.55688, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.06771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.07844, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84528, [ 3, -0.16667, 0.10636], [ 3, 0.16667, -0.10636]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30693, [ 3, -0.16667, -0.00358], [ 3, 0.16667, 0.00358]], [ 1.31920, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.32073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32687, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30079, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32380, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31766, [ 3, -0.16667, 0.00588], [ 3, 0.16667, -0.00588]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.32517, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.32517, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.57367, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.57367, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.74241, [ 3, -0.16667, 0.06315], [ 3, 0.16667, -0.06315]], [ -0.95257, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.95257, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.08296, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.08450, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.08450, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("DisagreeRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def DontKnow():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92189, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.87587, [ 3, -0.16667, 0.01202], [ 3, 0.16667, -0.01202]], [ 0.84979, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84979, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85133, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.86053, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.86974, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86974, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95564, [ 3, -0.16667, -0.01074], [ 3, 0.16667, 0.01074]], [ 0.96638, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22546, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23159, [ 3, -0.16667, -0.00256], [ 3, 0.16667, 0.00256]], [ 0.24080, [ 3, -0.16667, -0.00486], [ 3, 0.16667, 0.00486]], [ 0.26074, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21012, [ 3, -0.16667, 0.01176], [ 3, 0.16667, -0.01176]], [ 0.18864, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55075, [ 3, -0.16667, 0.08002], [ 3, 0.16667, -0.08002]], [ -0.92044, [ 3, -0.16667, 0.12374], [ 3, 0.16667, -0.12374]], [ -1.29320, [ 3, -0.16667, 0.10917], [ 3, 0.16667, -0.10917]], [ -1.57546, [ 3, -0.16667, 0.09025], [ 3, 0.16667, -0.09025]], [ -1.83471, [ 3, -0.16667, 0.07875], [ 3, 0.16667, -0.07875]], [ -2.04793, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -2.03413, [ 3, -0.16667, -0.01381], [ 3, 0.16667, 0.01381]], [ -1.71812, [ 3, -0.16667, -0.10124], [ 3, 0.16667, 0.10124]], [ -1.42666, [ 3, -0.16667, -0.17130], [ 3, 0.16667, 0.17130]], [ -0.69034, [ 3, -0.16667, -0.15621], [ 3, 0.16667, 0.15621]], [ -0.48939, [ 3, -0.16667, -0.04167], [ 3, 0.16667, 0.04167]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30693, [ 3, -0.16667, 0.00409], [ 3, 0.16667, -0.00409]], [ -1.31306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31153, [ 3, -0.16667, -0.00281], [ 3, 0.16667, 0.00281]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29926, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30846, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.12728, [ 3, -0.16667, 0.07670], [ 3, 0.16667, -0.07670]], [ -0.17799, [ 3, -0.16667, 0.09409], [ 3, 0.16667, -0.09409]], [ -0.43723, [ 3, -0.16667, 0.11147], [ 3, 0.16667, -0.11147]], [ -0.84681, [ 3, -0.16667, 0.17462], [ 3, 0.16667, -0.17462]], [ -1.48495, [ 3, -0.16667, 0.16284], [ 3, 0.16667, -0.16284]], [ -1.82387, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.82387, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.19963, [ 3, -0.16667, -0.21960], [ 3, 0.16667, 0.21960]], [ -0.50626, [ 3, -0.16667, -0.25618], [ 3, 0.16667, 0.25618]], [ 0.33744, [ 3, -0.16667, -0.13959], [ 3, 0.16667, 0.13959]], [ 0.47703, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94345, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.82994, [ 3, -0.16667, 0.02582], [ 3, 0.16667, -0.02582]], [ 0.78852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.78852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.79619, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 0.82073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.82073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.82073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.82073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92658, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.92811, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26849, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ -0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27309, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.27616, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ -0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27309, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.27156, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.26696, [ 3, -0.16667, -0.00460], [ 3, 0.16667, 0.00460]], [ -0.12123, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.13964, [ 3, -0.16667, 0.01611], [ 3, 0.16667, -0.01611]], [ -0.21787, [ 3, -0.16667, 0.02250], [ 3, 0.16667, -0.02250]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65958, [ 3, -0.16667, -0.06136], [ 3, 0.16667, 0.06136]], [ 0.87587, [ 3, -0.16667, -0.08181], [ 3, 0.16667, 0.08181]], [ 1.15046, [ 3, -0.16667, -0.07977], [ 3, 0.16667, 0.07977]], [ 1.35448, [ 3, -0.16667, -0.06929], [ 3, 0.16667, 0.06929]], [ 1.56617, [ 3, -0.16667, -0.07159], [ 3, 0.16667, 0.07159]], [ 1.78400, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.77173, [ 3, -0.16667, 0.01227], [ 3, 0.16667, -0.01227]], [ 1.56924, [ 3, -0.16667, 0.07235], [ 3, 0.16667, -0.07235]], [ 1.33761, [ 3, -0.16667, 0.15212], [ 3, 0.16667, -0.15212]], [ 0.65651, [ 3, -0.16667, 0.14368], [ 3, 0.16667, -0.14368]], [ 0.47550, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31621, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31468, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31468, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30394, [ 3, -0.16667, 0.00716], [ 3, 0.16667, -0.00716]], [ 1.27173, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.27019, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 1.26866, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.27173, [ 3, -0.16667, -0.00256], [ 3, 0.16667, 0.00256]], [ 1.28400, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.26252, [ 3, -0.16667, 0.00486], [ 3, 0.16667, -0.00486]], [ 1.25485, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.17952, [ 3, -0.16667, -0.01994], [ 3, 0.16667, 0.01994]], [ 0.20858, [ 3, -0.16667, -0.13090], [ 3, 0.16667, 0.13090]], [ 0.60589, [ 3, -0.16667, -0.12144], [ 3, 0.16667, 0.12144]], [ 0.93723, [ 3, -0.16667, -0.15187], [ 3, 0.16667, 0.15187]], [ 1.51708, [ 3, -0.16667, -0.14777], [ 3, 0.16667, 0.14777]], [ 1.82387, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.79320, [ 3, -0.16667, 0.03067], [ 3, 0.16667, -0.03067]], [ 1.17193, [ 3, -0.16667, 0.23675], [ 3, 0.16667, -0.23675]], [ 0.37272, [ 3, -0.16667, 0.25516], [ 3, 0.16667, -0.25516]], [ -0.35900, [ 3, -0.16667, 0.03375], [ 3, 0.16667, -0.03375]], [ -0.39275, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("DontKnow")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def DontKnowLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92189, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.87587, [ 3, -0.16667, 0.01202], [ 3, 0.16667, -0.01202]], [ 0.84979, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84979, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85133, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.86053, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.86974, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86974, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95564, [ 3, -0.16667, -0.01074], [ 3, 0.16667, 0.01074]], [ 0.96638, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22546, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23159, [ 3, -0.16667, -0.00256], [ 3, 0.16667, 0.00256]], [ 0.24080, [ 3, -0.16667, -0.00486], [ 3, 0.16667, 0.00486]], [ 0.26074, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21012, [ 3, -0.16667, 0.01176], [ 3, 0.16667, -0.01176]], [ 0.18864, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55075, [ 3, -0.16667, 0.08002], [ 3, 0.16667, -0.08002]], [ -0.92044, [ 3, -0.16667, 0.12374], [ 3, 0.16667, -0.12374]], [ -1.29320, [ 3, -0.16667, 0.10917], [ 3, 0.16667, -0.10917]], [ -1.57546, [ 3, -0.16667, 0.09025], [ 3, 0.16667, -0.09025]], [ -1.83471, [ 3, -0.16667, 0.07875], [ 3, 0.16667, -0.07875]], [ -2.04793, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -2.03413, [ 3, -0.16667, -0.01381], [ 3, 0.16667, 0.01381]], [ -1.71812, [ 3, -0.16667, -0.10124], [ 3, 0.16667, 0.10124]], [ -1.42666, [ 3, -0.16667, -0.17130], [ 3, 0.16667, 0.17130]], [ -0.69034, [ 3, -0.16667, -0.15621], [ 3, 0.16667, 0.15621]], [ -0.48939, [ 3, -0.16667, -0.04167], [ 3, 0.16667, 0.04167]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30693, [ 3, -0.16667, 0.00409], [ 3, 0.16667, -0.00409]], [ -1.31306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31153, [ 3, -0.16667, -0.00281], [ 3, 0.16667, 0.00281]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29926, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30846, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.12728, [ 3, -0.16667, 0.07670], [ 3, 0.16667, -0.07670]], [ -0.17799, [ 3, -0.16667, 0.09409], [ 3, 0.16667, -0.09409]], [ -0.43723, [ 3, -0.16667, 0.11147], [ 3, 0.16667, -0.11147]], [ -0.84681, [ 3, -0.16667, 0.17462], [ 3, 0.16667, -0.17462]], [ -1.48495, [ 3, -0.16667, 0.16284], [ 3, 0.16667, -0.16284]], [ -1.82387, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.82387, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.19963, [ 3, -0.16667, -0.21960], [ 3, 0.16667, 0.21960]], [ -0.50626, [ 3, -0.16667, -0.25618], [ 3, 0.16667, 0.25618]], [ 0.33744, [ 3, -0.16667, -0.13959], [ 3, 0.16667, 0.13959]], [ 0.47703, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98027, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97873, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.94805, [ 3, -0.16667, 0.00665], [ 3, 0.16667, -0.00665]], [ 0.93885, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.93885, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94038, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ 0.94652, [ 3, -0.16667, -0.00614], [ 3, 0.16667, 0.00614]], [ 0.97873, [ 3, -0.16667, -0.00895], [ 3, 0.16667, 0.00895]], [ 1.00021, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98794, [ 3, -0.16667, 0.00818], [ 3, 0.16667, -0.00818]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28843, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25469, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27309, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ -0.28230, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.52765, [ 3, -0.16667, -0.01994], [ 3, 0.16667, 0.01994]], [ 0.66111, [ 3, -0.16667, -0.05446], [ 3, 0.16667, 0.05446]], [ 0.85440, [ 3, -0.16667, -0.05804], [ 3, 0.16667, 0.05804]], [ 1.00933, [ 3, -0.16667, -0.01534], [ 3, 0.16667, 0.01534]], [ 1.02467, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.02620, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95257, [ 3, -0.16667, 0.04167], [ 3, 0.16667, -0.04167]], [ 0.77616, [ 3, -0.16667, 0.05676], [ 3, 0.16667, -0.05676]], [ 0.61202, [ 3, -0.16667, 0.04219], [ 3, 0.16667, -0.04219]], [ 0.52305, [ 3, -0.16667, 0.01534], [ 3, 0.16667, -0.01534]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29934, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33922, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.34076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33922, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33922, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.34229, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.34229, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.34076, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 1.33922, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.32849, [ 3, -0.16667, 0.00562], [ 3, 0.16667, -0.00562]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.07981, [ 3, -0.16667, -0.09460], [ 3, 0.16667, 0.09460]], [ 0.29142, [ 3, -0.16667, -0.12170], [ 3, 0.16667, 0.12170]], [ 0.65037, [ 3, -0.16667, -0.02454], [ 3, 0.16667, 0.02454]], [ 0.67492, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.66725, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.38192, [ 3, -0.16667, 0.11556], [ 3, 0.16667, -0.11556]], [ -0.02612, [ 3, -0.16667, 0.10329], [ 3, 0.16667, -0.10329]], [ -0.23781, [ 3, -0.16667, 0.02148], [ 3, 0.16667, -0.02148]], [ -0.25929, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("DontKnowLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def DontKnowRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98027, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97873, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.94805, [ 3, -0.16667, 0.00665], [ 3, 0.16667, -0.00665]], [ 0.93885, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.93885, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94038, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ 0.94652, [ 3, -0.16667, -0.00614], [ 3, 0.16667, 0.00614]], [ 0.97873, [ 3, -0.16667, -0.00895], [ 3, 0.16667, 0.00895]], [ 1.00021, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98794, [ 3, -0.16667, 0.00818], [ 3, 0.16667, -0.00818]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28843, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25469, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27309, [ 3, -0.16667, -0.00460], [ 3, 0.16667, 0.00460]], [ 0.28230, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.52765, [ 3, -0.16667, 0.01994], [ 3, 0.16667, -0.01994]], [ -0.66111, [ 3, -0.16667, 0.05446], [ 3, 0.16667, -0.05446]], [ -0.85440, [ 3, -0.16667, 0.05804], [ 3, 0.16667, -0.05804]], [ -1.00933, [ 3, -0.16667, 0.01534], [ 3, 0.16667, -0.01534]], [ -1.02467, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.02620, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.95257, [ 3, -0.16667, -0.04167], [ 3, 0.16667, 0.04167]], [ -0.77616, [ 3, -0.16667, -0.05676], [ 3, 0.16667, 0.05676]], [ -0.61202, [ 3, -0.16667, -0.04218], [ 3, 0.16667, 0.04218]], [ -0.52305, [ 3, -0.16667, -0.01534], [ 3, 0.16667, 0.01534]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29934, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33922, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.34076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33922, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33922, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.34229, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.34229, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.34076, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -1.33922, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.32849, [ 3, -0.16667, -0.00562], [ 3, 0.16667, 0.00562]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.07981, [ 3, -0.16667, 0.09460], [ 3, 0.16667, -0.09460]], [ -0.29142, [ 3, -0.16667, 0.12170], [ 3, 0.16667, -0.12170]], [ -0.65037, [ 3, -0.16667, 0.02454], [ 3, 0.16667, -0.02454]], [ -0.67492, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.66725, [ 3, -0.16667, -0.00767], [ 3, 0.16667, 0.00767]], [ -0.38192, [ 3, -0.16667, -0.11556], [ 3, 0.16667, 0.11556]], [ 0.02612, [ 3, -0.16667, -0.10329], [ 3, 0.16667, 0.10329]], [ 0.23781, [ 3, -0.16667, -0.02148], [ 3, 0.16667, 0.02148]], [ 0.25929, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92189, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.87587, [ 3, -0.16667, 0.01202], [ 3, 0.16667, -0.01202]], [ 0.84979, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84979, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85133, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.86053, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.86974, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86974, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95564, [ 3, -0.16667, -0.01074], [ 3, 0.16667, 0.01074]], [ 0.96638, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22546, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23159, [ 3, -0.16667, 0.00256], [ 3, 0.16667, -0.00256]], [ -0.24080, [ 3, -0.16667, 0.00486], [ 3, 0.16667, -0.00486]], [ -0.26074, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25767, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21012, [ 3, -0.16667, -0.01176], [ 3, 0.16667, 0.01176]], [ -0.18864, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.55075, [ 3, -0.16667, -0.08002], [ 3, 0.16667, 0.08002]], [ 0.92044, [ 3, -0.16667, -0.12374], [ 3, 0.16667, 0.12374]], [ 1.29320, [ 3, -0.16667, -0.10917], [ 3, 0.16667, 0.10917]], [ 1.57546, [ 3, -0.16667, -0.09025], [ 3, 0.16667, 0.09025]], [ 1.83471, [ 3, -0.16667, -0.07875], [ 3, 0.16667, 0.07875]], [ 2.04793, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 2.03413, [ 3, -0.16667, 0.01381], [ 3, 0.16667, -0.01381]], [ 1.71812, [ 3, -0.16667, 0.10124], [ 3, 0.16667, -0.10124]], [ 1.42666, [ 3, -0.16667, 0.17130], [ 3, 0.16667, -0.17130]], [ 0.69034, [ 3, -0.16667, 0.15621], [ 3, 0.16667, -0.15621]], [ 0.48939, [ 3, -0.16667, 0.04167], [ 3, 0.16667, -0.04167]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30693, [ 3, -0.16667, -0.00409], [ 3, 0.16667, 0.00409]], [ 1.31306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31153, [ 3, -0.16667, 0.00281], [ 3, 0.16667, -0.00281]], [ 1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29926, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30846, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000])
    keys.append([ [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.12728, [ 3, -0.16667, -0.07670], [ 3, 0.16667, 0.07670]], [ 0.17799, [ 3, -0.16667, -0.09409], [ 3, 0.16667, 0.09409]], [ 0.43723, [ 3, -0.16667, -0.11147], [ 3, 0.16667, 0.11147]], [ 0.84681, [ 3, -0.16667, -0.17462], [ 3, 0.16667, 0.17462]], [ 1.48495, [ 3, -0.16667, -0.16284], [ 3, 0.16667, 0.16284]], [ 1.82387, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.82387, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.19963, [ 3, -0.16667, 0.21960], [ 3, 0.16667, -0.21960]], [ 0.50626, [ 3, -0.16667, 0.25618], [ 3, 0.16667, -0.25618]], [ -0.33744, [ 3, -0.16667, 0.13959], [ 3, 0.16667, -0.13959]], [ -0.47703, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("DontKnowRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Wait():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ 1.06302, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.06302, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.06302, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92649, [ 3, -0.16667, 0.08309], [ 3, 0.16667, -0.08309]], [ 0.56447, [ 3, -0.16667, 0.09818], [ 3, 0.16667, -0.09818]], [ 0.33744, [ 3, -0.16667, 0.01994], [ 3, 0.16667, -0.01994]], [ 0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46169, [ 3, -0.16667, -0.07312], [ 3, 0.16667, 0.07312]], [ 0.75622, [ 3, -0.16667, -0.07798], [ 3, 0.16667, 0.07798]], [ 0.92956, [ 3, -0.16667, -0.04142], [ 3, 0.16667, 0.04142]], [ 1.00473, [ 3, -0.16667, -0.01227], [ 3, 0.16667, 0.01227]], [ 1.01700, [ 3, -0.16667, -0.00409], [ 3, 0.16667, 0.00409]], [ 1.02927, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ 0.36658, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36658, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36658, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32823, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32823, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32823, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32823, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32823, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32056, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32210, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.30983, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.30829, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.32363, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 0.34051, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ -0.59677, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.59677, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.59677, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.69341, [ 3, -0.16667, 0.02582], [ 3, 0.16667, -0.02582]], [ -0.75170, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -0.75477, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ -0.75937, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ -0.76091, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.69341, [ 3, -0.16667, -0.01074], [ 3, 0.16667, 0.01074]], [ -0.68267, [ 3, -0.16667, -0.01074], [ 3, 0.16667, 0.01074]], [ -0.61057, [ 3, -0.16667, -0.01764], [ 3, 0.16667, 0.01764]], [ -0.57683, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.57683, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.57683, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ -1.43732, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.43732, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.43578, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.45419, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.45726, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.45572, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.45572, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.45572, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.43271, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.43271, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.43732, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.43425, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -1.43271, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.43425, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ 0.39726, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.39726, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.39880, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.80684, [ 3, -0.16667, -0.09051], [ 3, 0.16667, 0.09051]], [ 0.94183, [ 3, -0.16667, -0.03477], [ 3, 0.16667, 0.03477]], [ 1.01547, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01547, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.81758, [ 3, -0.16667, 0.08105], [ 3, 0.16667, -0.08105]], [ 0.52765, [ 3, -0.16667, 0.02454], [ 3, 0.16667, -0.02454]], [ 0.50311, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.50158, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ 0.93885, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.93885, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.93885, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.69341, [ 3, -0.16667, 0.09562], [ 3, 0.16667, -0.09562]], [ 0.36513, [ 3, -0.16667, 0.07159], [ 3, 0.16667, -0.07159]], [ 0.26389, [ 3, -0.16667, 0.01994], [ 3, 0.16667, -0.01994]], [ 0.24395, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24395, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.43877, [ 3, -0.16667, -0.08181], [ 3, 0.16667, 0.08181]], [ 0.73483, [ 3, -0.16667, -0.08463], [ 3, 0.16667, 0.08463]], [ 0.94652, [ 3, -0.16667, -0.01381], [ 3, 0.16667, 0.01381]], [ 0.96033, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96033, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96033, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ -0.25622, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25622, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25469, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25469, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25622, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25622, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25315, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25315, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24855, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24855, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24241, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ -0.26389, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.26542, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ 0.46323, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46323, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46323, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.51385, [ 3, -0.16667, -0.02506], [ 3, 0.16667, 0.02506]], [ 0.61356, [ 3, -0.16667, -0.02838], [ 3, 0.16667, 0.02838]], [ 0.68412, [ 3, -0.16667, -0.01790], [ 3, 0.16667, 0.01790]], [ 0.72094, [ 3, -0.16667, -0.00997], [ 3, 0.16667, 0.00997]], [ 0.74395, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.70713, [ 3, -0.16667, 0.01329], [ 3, 0.16667, -0.01329]], [ 0.66418, [ 3, -0.16667, 0.01202], [ 3, 0.16667, -0.01202]], [ 0.63503, [ 3, -0.16667, 0.01483], [ 3, 0.16667, -0.01483]], [ 0.57521, [ 3, -0.16667, 0.01841], [ 3, 0.16667, -0.01841]], [ 0.52459, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.52459, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ 1.25025, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.24872, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.24872, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29014, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29014, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29014, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ 1.28400, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28553, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28400, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.27019, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.26866, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000])
    keys.append([ [ -0.34212, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.34212, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.34212, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.52927, [ 3, -0.16667, 0.06750], [ 3, 0.16667, -0.06750]], [ -0.74710, [ 3, -0.16667, 0.05983], [ 3, 0.16667, -0.05983]], [ -0.88823, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.88669, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.88823, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.88823, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.88516, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.78085, [ 3, -0.16667, -0.07619], [ 3, 0.16667, 0.07619]], [ -0.42803, [ 3, -0.16667, -0.05676], [ 3, 0.16667, 0.05676]], [ -0.37127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.37127, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Wait")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def WaveHandLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.20000, 0.64000, 1.40000, 2.08000, 2.64000, 3.32000, 4.44000, 4.80000])
    keys.append([ [ 0.95112, [ 3, -0.06667, 0.00000], [ 3, 0.14667, 0.00000]], [ 0.24702, [ 3, -0.14667, 0.25948], [ 3, 0.25333, -0.44820]], [ -1.17193, [ 3, -0.25333, 0.00000], [ 3, 0.22667, 0.00000]], [ -1.08910, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ -1.26091, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ -1.14892, [ 3, -0.22667, -0.11198], [ 3, 0.37333, 0.18444]], [ 1.02015, [ 3, -0.37333, 0.00000], [ 3, 0.12000, 0.00000]], [ 0.95112, [ 3, -0.12000, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.20000, 0.64000, 1.40000, 2.08000, 2.64000, 3.32000, 4.44000, 4.80000])
    keys.append([ [ 0.27463, [ 3, -0.06667, 0.00000], [ 3, 0.14667, 0.00000]], [ 0.24241, [ 3, -0.14667, 0.00000], [ 3, 0.25333, 0.00000]], [ 0.95419, [ 3, -0.25333, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.46024, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ 0.96033, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.32832, [ 3, -0.22667, 0.04750], [ 3, 0.37333, -0.07823]], [ 0.25008, [ 3, -0.37333, 0.00000], [ 3, 0.12000, 0.00000]], [ 0.27463, [ 3, -0.12000, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.20000, 0.64000, 1.40000, 2.08000, 2.64000, 3.32000, 3.72000, 4.44000, 4.80000])
    keys.append([ [ -0.50771, [ 3, -0.06667, 0.00000], [ 3, 0.14667, 0.00000]], [ 0.31298, [ 3, -0.14667, 0.00000], [ 3, 0.25333, 0.00000]], [ -0.56447, [ 3, -0.25333, 0.00000], [ 3, 0.22667, 0.00000]], [ -0.39113, [ 3, -0.22667, -0.03954], [ 3, 0.18667, 0.03256]], [ -0.34818, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ -0.38192, [ 3, -0.22667, 0.03375], [ 3, 0.13333, -0.01985]], [ -0.97738, [ 3, -0.13333, 0.00000], [ 3, 0.24000, 0.00000]], [ -0.82678, [ 3, -0.24000, -0.10437], [ 3, 0.12000, 0.05219]], [ -0.50771, [ 3, -0.12000, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.20000, 0.64000, 1.40000, 1.68000, 2.08000, 2.40000, 2.64000, 3.04000, 3.32000, 3.72000, 4.44000, 4.80000])
    keys.append([ [ -1.30548, [ 3, -0.06667, 0.00000], [ 3, 0.14667, 0.00000]], [ -1.38524, [ 3, -0.14667, 0.00000], [ 3, 0.25333, 0.00000]], [ -0.24241, [ 3, -0.25333, 0.00000], [ 3, 0.09333, 0.00000]], [ -0.34907, [ 3, -0.09333, 0.09496], [ 3, 0.13333, -0.13565]], [ -0.93425, [ 3, -0.13333, 0.00000], [ 3, 0.10667, 0.00000]], [ -0.68068, [ 3, -0.10667, -0.14138], [ 3, 0.08000, 0.10604]], [ -0.19199, [ 3, -0.08000, 0.00000], [ 3, 0.13333, 0.00000]], [ -0.26180, [ 3, -0.13333, 0.06981], [ 3, 0.09333, -0.04887]], [ -0.70722, [ 3, -0.09333, 0.10397], [ 3, 0.13333, -0.14852]], [ -1.01927, [ 3, -0.13333, 0.06647], [ 3, 0.24000, -0.11965]], [ -1.26559, [ 3, -0.24000, 0.06360], [ 3, 0.12000, -0.03180]], [ -1.30548, [ 3, -0.12000, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.20000, 4.80000])
    keys.append([ [ 0.19946, [ 3, -0.06667, 0.00000], [ 3, 1.53333, 0.00000]], [ 0.19946, [ 3, -1.53333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LHand")
    times.append([ 0.20000, 4.80000])
    keys.append([ [ 0.97280, [ 3, -0.06667, 0.00000], [ 3, 1.53333, 0.00000]], [ 0.97280, [ 3, -1.53333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.20000, 0.72000, 1.48000, 2.16000, 2.72000, 3.40000, 4.52000, 4.80000])
    keys.append([ [ 0.92343, [ 3, -0.06667, 0.00000], [ 3, 0.17333, 0.00000]], [ 1.11824, [ 3, -0.17333, 0.00000], [ 3, 0.25333, 0.00000]], [ 0.92803, [ 3, -0.25333, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.94030, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ 0.86207, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.89735, [ 3, -0.22667, 0.00000], [ 3, 0.37333, 0.00000]], [ 0.84212, [ 3, -0.37333, 0.00000], [ 3, 0.09333, 0.00000]], [ 0.92343, [ 3, -0.09333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.20000, 0.72000, 1.48000, 2.16000, 2.72000, 3.40000, 4.52000, 4.80000])
    keys.append([ [ -0.24540, [ 3, -0.06667, 0.00000], [ 3, 0.17333, 0.00000]], [ -0.36352, [ 3, -0.17333, 0.00000], [ 3, 0.25333, 0.00000]], [ -0.22699, [ 3, -0.25333, -0.02572], [ 3, 0.22667, 0.02301]], [ -0.20398, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ -0.21779, [ 3, -0.18667, 0.00670], [ 3, 0.22667, -0.00813]], [ -0.24847, [ 3, -0.22667, 0.00000], [ 3, 0.37333, 0.00000]], [ -0.22699, [ 3, -0.37333, 0.00000], [ 3, 0.09333, 0.00000]], [ -0.24540, [ 3, -0.09333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.20000, 0.72000, 1.48000, 2.16000, 2.72000, 3.40000, 4.52000, 4.80000])
    keys.append([ [ 0.44030, [ 3, -0.06667, 0.00000], [ 3, 0.17333, 0.00000]], [ 0.80386, [ 3, -0.17333, 0.00000], [ 3, 0.25333, 0.00000]], [ 0.69188, [ 3, -0.25333, 0.01372], [ 3, 0.22667, -0.01227]], [ 0.67960, [ 3, -0.22667, 0.01227], [ 3, 0.18667, -0.01011]], [ 0.61057, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.75324, [ 3, -0.22667, 0.00000], [ 3, 0.37333, 0.00000]], [ 0.67040, [ 3, -0.37333, 0.08284], [ 3, 0.09333, -0.02071]], [ 0.44030, [ 3, -0.09333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.20000, 0.72000, 1.48000, 2.16000, 2.72000, 3.40000, 4.52000, 4.80000])
    keys.append([ [ 1.28852, [ 3, -0.06667, 0.00000], [ 3, 0.17333, 0.00000]], [ 1.37902, [ 3, -0.17333, 0.00000], [ 3, 0.25333, 0.00000]], [ 1.29005, [ 3, -0.25333, 0.03454], [ 3, 0.22667, -0.03091]], [ 1.18267, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ 1.24863, [ 3, -0.18667, -0.02055], [ 3, 0.22667, 0.02496]], [ 1.31920, [ 3, -0.22667, 0.00000], [ 3, 0.37333, 0.00000]], [ 1.18421, [ 3, -0.37333, 0.00000], [ 3, 0.09333, 0.00000]], [ 1.28852, [ 3, -0.09333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.20000, 4.80000])
    keys.append([ [ -0.28221, [ 3, -0.06667, 0.00000], [ 3, 1.53333, 0.00000]], [ -0.28221, [ 3, -1.53333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RHand")
    times.append([ 0.20000, 4.80000])
    keys.append([ [ 0.97280, [ 3, -0.06667, 0.00000], [ 3, 1.53333, 0.00000]], [ 0.97280, [ 3, -1.53333, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("WaveHandLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def WaveHandRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.20000, 0.72000, 1.48000, 2.16000, 2.72000, 3.40000, 4.52000, 4.80000])
    keys.append([ [ 0.92343, [ 3, -0.06667, 0.00000], [ 3, 0.17333, 0.00000]], [ 1.11824, [ 3, -0.17333, 0.00000], [ 3, 0.25333, 0.00000]], [ 0.92803, [ 3, -0.25333, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.94030, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ 0.86207, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.89735, [ 3, -0.22667, 0.00000], [ 3, 0.37333, 0.00000]], [ 0.84212, [ 3, -0.37333, 0.00000], [ 3, 0.09333, 0.00000]], [ 0.92343, [ 3, -0.09333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.20000, 0.72000, 1.48000, 2.16000, 2.72000, 3.40000, 4.52000, 4.80000])
    keys.append([ [ 0.24540, [ 3, -0.06667, 0.00000], [ 3, 0.17333, 0.00000]], [ 0.36352, [ 3, -0.17333, 0.00000], [ 3, 0.25333, 0.00000]], [ 0.22699, [ 3, -0.25333, 0.02572], [ 3, 0.22667, -0.02301]], [ 0.20398, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ 0.21779, [ 3, -0.18667, -0.00670], [ 3, 0.22667, 0.00813]], [ 0.24847, [ 3, -0.22667, 0.00000], [ 3, 0.37333, 0.00000]], [ 0.22699, [ 3, -0.37333, 0.00000], [ 3, 0.09333, 0.00000]], [ 0.24540, [ 3, -0.09333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.20000, 0.72000, 1.48000, 2.16000, 2.72000, 3.40000, 4.52000, 4.80000])
    keys.append([ [ -0.44030, [ 3, -0.06667, 0.00000], [ 3, 0.17333, 0.00000]], [ -0.80386, [ 3, -0.17333, 0.00000], [ 3, 0.25333, 0.00000]], [ -0.69188, [ 3, -0.25333, -0.01372], [ 3, 0.22667, 0.01227]], [ -0.67960, [ 3, -0.22667, -0.01227], [ 3, 0.18667, 0.01011]], [ -0.61057, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ -0.75324, [ 3, -0.22667, 0.00000], [ 3, 0.37333, 0.00000]], [ -0.67040, [ 3, -0.37333, -0.08284], [ 3, 0.09333, 0.02071]], [ -0.44030, [ 3, -0.09333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.20000, 0.72000, 1.48000, 2.16000, 2.72000, 3.40000, 4.52000, 4.80000])
    keys.append([ [ -1.28852, [ 3, -0.06667, 0.00000], [ 3, 0.17333, 0.00000]], [ -1.37902, [ 3, -0.17333, 0.00000], [ 3, 0.25333, 0.00000]], [ -1.29005, [ 3, -0.25333, -0.03454], [ 3, 0.22667, 0.03091]], [ -1.18267, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ -1.24863, [ 3, -0.18667, 0.02055], [ 3, 0.22667, -0.02496]], [ -1.31920, [ 3, -0.22667, 0.00000], [ 3, 0.37333, 0.00000]], [ -1.18421, [ 3, -0.37333, 0.00000], [ 3, 0.09333, 0.00000]], [ -1.28852, [ 3, -0.09333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.20000, 4.80000])
    keys.append([ [ 0.28221, [ 3, -0.06667, 0.00000], [ 3, 1.53333, 0.00000]], [ 0.28221, [ 3, -1.53333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LHand")
    times.append([ 0.20000, 4.80000])
    keys.append([ [ 0.97280, [ 3, -0.06667, 0.00000], [ 3, 1.53333, 0.00000]], [ 0.97280, [ 3, -1.53333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.20000, 0.64000, 1.40000, 2.08000, 2.64000, 3.32000, 4.44000, 4.80000])
    keys.append([ [ 0.95112, [ 3, -0.06667, 0.00000], [ 3, 0.14667, 0.00000]], [ 0.24702, [ 3, -0.14667, 0.25948], [ 3, 0.25333, -0.44820]], [ -1.17193, [ 3, -0.25333, 0.00000], [ 3, 0.22667, 0.00000]], [ -1.08910, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ -1.26091, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ -1.14892, [ 3, -0.22667, -0.11198], [ 3, 0.37333, 0.18444]], [ 1.02015, [ 3, -0.37333, 0.00000], [ 3, 0.12000, 0.00000]], [ 0.95112, [ 3, -0.12000, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.20000, 0.64000, 1.40000, 2.08000, 2.64000, 3.32000, 4.44000, 4.80000])
    keys.append([ [ -0.27463, [ 3, -0.06667, 0.00000], [ 3, 0.14667, 0.00000]], [ -0.24241, [ 3, -0.14667, 0.00000], [ 3, 0.25333, 0.00000]], [ -0.95419, [ 3, -0.25333, 0.00000], [ 3, 0.22667, 0.00000]], [ -0.46024, [ 3, -0.22667, 0.00000], [ 3, 0.18667, 0.00000]], [ -0.96033, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ -0.32832, [ 3, -0.22667, -0.04750], [ 3, 0.37333, 0.07823]], [ -0.25008, [ 3, -0.37333, 0.00000], [ 3, 0.12000, 0.00000]], [ -0.27463, [ 3, -0.12000, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.20000, 0.64000, 1.40000, 2.08000, 2.64000, 3.32000, 3.72000, 4.44000, 4.80000])
    keys.append([ [ 0.50771, [ 3, -0.06667, 0.00000], [ 3, 0.14667, 0.00000]], [ -0.31298, [ 3, -0.14667, 0.00000], [ 3, 0.25333, 0.00000]], [ 0.56447, [ 3, -0.25333, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.39113, [ 3, -0.22667, 0.03954], [ 3, 0.18667, -0.03256]], [ 0.34818, [ 3, -0.18667, 0.00000], [ 3, 0.22667, 0.00000]], [ 0.38192, [ 3, -0.22667, -0.03375], [ 3, 0.13333, 0.01985]], [ 0.97738, [ 3, -0.13333, 0.00000], [ 3, 0.24000, 0.00000]], [ 0.82678, [ 3, -0.24000, 0.10437], [ 3, 0.12000, -0.05219]], [ 0.50771, [ 3, -0.12000, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.20000, 0.64000, 1.40000, 1.68000, 2.08000, 2.40000, 2.64000, 3.04000, 3.32000, 3.72000, 4.44000, 4.80000])
    keys.append([ [ 1.30548, [ 3, -0.06667, 0.00000], [ 3, 0.14667, 0.00000]], [ 1.38524, [ 3, -0.14667, 0.00000], [ 3, 0.25333, 0.00000]], [ 0.24241, [ 3, -0.25333, 0.00000], [ 3, 0.09333, 0.00000]], [ 0.34907, [ 3, -0.09333, -0.09496], [ 3, 0.13333, 0.13565]], [ 0.93425, [ 3, -0.13333, 0.00000], [ 3, 0.10667, 0.00000]], [ 0.68068, [ 3, -0.10667, 0.14138], [ 3, 0.08000, -0.10604]], [ 0.19199, [ 3, -0.08000, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.26180, [ 3, -0.13333, -0.06981], [ 3, 0.09333, 0.04887]], [ 0.70722, [ 3, -0.09333, -0.10397], [ 3, 0.13333, 0.14852]], [ 1.01927, [ 3, -0.13333, -0.06647], [ 3, 0.24000, 0.11965]], [ 1.26559, [ 3, -0.24000, -0.06360], [ 3, 0.12000, 0.03180]], [ 1.30548, [ 3, -0.12000, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.20000, 4.80000])
    keys.append([ [ -0.19946, [ 3, -0.06667, 0.00000], [ 3, 1.53333, 0.00000]], [ -0.19946, [ 3, -1.53333, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RHand")
    times.append([ 0.20000, 4.80000])
    keys.append([ [ 0.97280, [ 3, -0.06667, 0.00000], [ 3, 1.53333, 0.00000]], [ 0.97280, [ 3, -1.53333, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("WaveHandRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def ForgetItLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92044, [ 3, -0.16667, 0.00298], [ 3, 0.16667, -0.00298]], [ 0.80386, [ 3, -0.16667, 0.02148], [ 3, 0.16667, -0.02148]], [ 0.78238, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.78392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.61978, [ 3, -0.16667, 0.09204], [ 3, 0.16667, -0.09204]], [ 0.23168, [ 3, -0.16667, 0.08999], [ 3, 0.16667, -0.08999]], [ 0.07981, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.22554, [ 3, -0.13333, -0.10073], [ 3, 0.13333, 0.10073]], [ 0.68421, [ 3, -0.13333, -0.09249], [ 3, 0.16667, 0.11562]], [ 0.84988, [ 3, -0.16667, -0.03987], [ 3, 0.16667, 0.03987]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25622, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22707, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25929, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25929, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26542, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.21327, [ 3, -0.16667, 0.01193], [ 3, 0.13333, -0.00955]], [ 0.20100, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.24088, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23935, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.45095, [ 3, -0.16667, 0.01066], [ 3, 0.16667, -0.01066]], [ -0.69946, [ 3, -0.16667, 0.08463], [ 3, 0.16667, -0.08463]], [ -0.95871, [ 3, -0.16667, 0.07414], [ 3, 0.16667, -0.07414]], [ -1.14432, [ 3, -0.16667, 0.06647], [ 3, 0.16667, -0.06647]], [ -1.35755, [ 3, -0.16667, 0.06238], [ 3, 0.16667, -0.06238]], [ -1.51862, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33761, [ 3, -0.16667, -0.18101], [ 3, 0.13333, 0.14481]], [ -0.40647, [ 3, -0.13333, -0.00920], [ 3, 0.13333, 0.00920]], [ -0.39726, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.41567, [ 3, -0.16667, 0.00717], [ 3, 0.16667, -0.00717]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29167, [ 3, -0.16667, 0.00232], [ 3, 0.16667, -0.00232]], [ -1.30241, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29474, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.29320, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32542, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32542, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33309, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ -1.28707, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ -1.28707, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29014, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.00925, [ 3, -0.16667, 0.08384], [ 3, 0.16667, -0.08384]], [ -0.22085, [ 3, -0.16667, 0.09971], [ 3, 0.16667, -0.09971]], [ -0.58901, [ 3, -0.16667, 0.10533], [ 3, 0.16667, -0.10533]], [ -0.85286, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.85440, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.62890, [ 3, -0.16667, -0.11403], [ 3, 0.16667, 0.11403]], [ -0.17023, [ 3, -0.16667, -0.18096], [ 3, 0.13333, 0.14476]], [ 0.34826, [ 3, -0.13333, -0.15033], [ 3, 0.13333, 0.15033]], [ 0.73176, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.31298, [ 3, -0.16667, 0.03076], [ 3, 0.16667, -0.03076]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95104, [ 3, -0.16667, 0.00008], [ 3, 0.16667, -0.00008]], [ 0.87894, [ 3, -0.16667, 0.01534], [ 3, 0.16667, -0.01534]], [ 0.85900, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ 0.85133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87894, [ 3, -0.16667, -0.00639], [ 3, 0.16667, 0.00639]], [ 0.88968, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.88968, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.88968, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.93570, [ 3, -0.16667, -0.01024], [ 3, 0.16667, 0.01024]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25767, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.25614, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25614, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25614, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25000, [ 3, -0.16667, -0.00614], [ 3, 0.16667, 0.00614]], [ -0.14569, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ -0.14722, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ -0.14722, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.16410, [ 3, -0.16667, 0.01687], [ 3, 0.16667, -0.01687]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.52160, [ 3, -0.16667, -0.01389], [ 3, 0.16667, 0.01389]], [ 0.76091, [ 3, -0.16667, -0.09025], [ 3, 0.16667, 0.09025]], [ 1.06310, [ 3, -0.16667, -0.07619], [ 3, 0.16667, 0.07619]], [ 1.21804, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.16435, [ 3, -0.16667, 0.02659], [ 3, 0.16667, -0.02659]], [ 1.05850, [ 3, -0.16667, 0.04755], [ 3, 0.16667, -0.04755]], [ 0.87902, [ 3, -0.16667, 0.03260], [ 3, 0.13333, -0.02608]], [ 0.85295, [ 3, -0.13333, 0.00920], [ 3, 0.13333, -0.00920]], [ 0.82380, [ 3, -0.13333, 0.02341], [ 3, 0.16667, -0.02926]], [ 0.69494, [ 3, -0.16667, 0.05268], [ 3, 0.16667, -0.05268]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.26397, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28085, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28085, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28545, [ 3, -0.16667, -0.00281], [ 3, 0.16667, 0.00281]], [ 1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28698, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ 1.28698, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ 1.28698, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28698, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.00464, [ 3, -0.16667, -0.07620], [ 3, 0.16667, 0.07620]], [ 0.25775, [ 3, -0.16667, -0.09127], [ 3, 0.16667, 0.09127]], [ 0.55228, [ 3, -0.16667, -0.07875], [ 3, 0.16667, 0.07875]], [ 0.73023, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.71949, [ 3, -0.16667, 0.01074], [ 3, 0.16667, -0.01074]], [ 0.46331, [ 3, -0.16667, 0.09409], [ 3, 0.16667, -0.09409]], [ 0.15498, [ 3, -0.16667, 0.01726], [ 3, 0.13333, -0.01381]], [ 0.14117, [ 3, -0.13333, 0.01381], [ 3, 0.13333, -0.01381]], [ 0.03072, [ 3, -0.13333, 0.04363], [ 3, 0.16667, -0.05454]], [ -0.15336, [ 3, -0.16667, 0.03836], [ 3, 0.16667, -0.03836]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("ForgetItLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def ForgetItRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95104, [ 3, -0.16667, 0.00008], [ 3, 0.16667, -0.00008]], [ 0.87894, [ 3, -0.16667, 0.01534], [ 3, 0.16667, -0.01534]], [ 0.85900, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ 0.85133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87894, [ 3, -0.16667, -0.00639], [ 3, 0.16667, 0.00639]], [ 0.88968, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.88968, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.88968, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.93570, [ 3, -0.16667, -0.01024], [ 3, 0.16667, 0.01024]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25767, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.25614, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25614, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25460, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25614, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25000, [ 3, -0.16667, 0.00614], [ 3, 0.16667, -0.00614]], [ 0.14569, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.14722, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.14722, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.16410, [ 3, -0.16667, -0.01687], [ 3, 0.16667, 0.01687]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.52160, [ 3, -0.16667, 0.01389], [ 3, 0.16667, -0.01389]], [ -0.76091, [ 3, -0.16667, 0.09025], [ 3, 0.16667, -0.09025]], [ -1.06310, [ 3, -0.16667, 0.07619], [ 3, 0.16667, -0.07619]], [ -1.21804, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.16435, [ 3, -0.16667, -0.02659], [ 3, 0.16667, 0.02659]], [ -1.05850, [ 3, -0.16667, -0.04755], [ 3, 0.16667, 0.04755]], [ -0.87902, [ 3, -0.16667, -0.03260], [ 3, 0.13333, 0.02608]], [ -0.85295, [ 3, -0.13333, -0.00920], [ 3, 0.13333, 0.00920]], [ -0.82380, [ 3, -0.13333, -0.02341], [ 3, 0.16667, 0.02926]], [ -0.69494, [ 3, -0.16667, -0.05268], [ 3, 0.16667, 0.05268]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.26397, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28085, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28085, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28545, [ 3, -0.16667, 0.00281], [ 3, 0.16667, -0.00281]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28698, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ -1.28698, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ -1.28698, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28698, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.00464, [ 3, -0.16667, 0.07620], [ 3, 0.16667, -0.07620]], [ -0.25775, [ 3, -0.16667, 0.09127], [ 3, 0.16667, -0.09127]], [ -0.55228, [ 3, -0.16667, 0.07875], [ 3, 0.16667, -0.07875]], [ -0.73023, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.71949, [ 3, -0.16667, -0.01074], [ 3, 0.16667, 0.01074]], [ -0.46331, [ 3, -0.16667, -0.09409], [ 3, 0.16667, 0.09409]], [ -0.15498, [ 3, -0.16667, -0.01726], [ 3, 0.13333, 0.01381]], [ -0.14117, [ 3, -0.13333, -0.01381], [ 3, 0.13333, 0.01381]], [ -0.03072, [ 3, -0.13333, -0.04363], [ 3, 0.16667, 0.05454]], [ 0.15336, [ 3, -0.16667, -0.03836], [ 3, 0.16667, 0.03836]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92044, [ 3, -0.16667, 0.00298], [ 3, 0.16667, -0.00298]], [ 0.80386, [ 3, -0.16667, 0.02148], [ 3, 0.16667, -0.02148]], [ 0.78238, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.78392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.61978, [ 3, -0.16667, 0.09204], [ 3, 0.16667, -0.09204]], [ 0.23168, [ 3, -0.16667, 0.08999], [ 3, 0.16667, -0.08999]], [ 0.07981, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ 0.22554, [ 3, -0.13333, -0.10073], [ 3, 0.13333, 0.10073]], [ 0.68421, [ 3, -0.13333, -0.09249], [ 3, 0.16667, 0.11562]], [ 0.84988, [ 3, -0.16667, -0.03987], [ 3, 0.16667, 0.03987]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25622, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22707, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25929, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25929, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26542, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.21327, [ 3, -0.16667, -0.01193], [ 3, 0.13333, 0.00955]], [ -0.20100, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ -0.24088, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23935, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.45095, [ 3, -0.16667, -0.01066], [ 3, 0.16667, 0.01066]], [ 0.69946, [ 3, -0.16667, -0.08463], [ 3, 0.16667, 0.08463]], [ 0.95871, [ 3, -0.16667, -0.07414], [ 3, 0.16667, 0.07414]], [ 1.14432, [ 3, -0.16667, -0.06647], [ 3, 0.16667, 0.06647]], [ 1.35755, [ 3, -0.16667, -0.06238], [ 3, 0.16667, 0.06238]], [ 1.51862, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33761, [ 3, -0.16667, 0.18101], [ 3, 0.13333, -0.14481]], [ 0.40647, [ 3, -0.13333, 0.00920], [ 3, 0.13333, -0.00920]], [ 0.39726, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.41567, [ 3, -0.16667, -0.00717], [ 3, 0.16667, 0.00717]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29167, [ 3, -0.16667, -0.00232], [ 3, 0.16667, 0.00232]], [ 1.30241, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29474, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.29320, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32542, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32542, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33309, [ 3, -0.16667, 0.00000], [ 3, 0.13333, 0.00000]], [ 1.28707, [ 3, -0.13333, 0.00000], [ 3, 0.13333, 0.00000]], [ 1.28707, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29014, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.40000, 4.80000, 5.30000, 5.80000])
    keys.append([ [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.00925, [ 3, -0.16667, -0.08384], [ 3, 0.16667, 0.08384]], [ 0.22085, [ 3, -0.16667, -0.09971], [ 3, 0.16667, 0.09971]], [ 0.58901, [ 3, -0.16667, -0.10533], [ 3, 0.16667, 0.10533]], [ 0.85286, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.85440, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.62890, [ 3, -0.16667, 0.11403], [ 3, 0.16667, -0.11403]], [ 0.17023, [ 3, -0.16667, 0.18096], [ 3, 0.13333, -0.14476]], [ -0.34826, [ 3, -0.13333, 0.15033], [ 3, 0.13333, -0.15033]], [ -0.73176, [ 3, -0.13333, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.31298, [ 3, -0.16667, -0.03076], [ 3, 0.16667, 0.03076]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("ForgetItRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def OhYesLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.83761, [ 3, -0.33333, 0.11352], [ 3, 0.16667, -0.05676]], [ 0.09822, [ 3, -0.16667, 0.15391], [ 3, 0.16667, -0.15391]], [ -0.08586, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.58756, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23168, [ 3, -0.16667, 0.06443], [ 3, 0.16667, -0.06443]], [ 0.16725, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.39121, [ 3, -0.16667, -0.12349], [ 3, 0.16667, 0.12349]], [ 0.90817, [ 3, -0.16667, -0.04295], [ 3, 0.16667, 0.04295]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.16725, [ 3, -0.33333, 0.01534], [ 3, 0.16667, -0.00767]], [ 0.15958, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.15804, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.09055, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09515, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09362, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.11816, [ 3, -0.16667, -0.00869], [ 3, 0.16667, 0.00869]], [ 0.14577, [ 3, -0.16667, -0.02608], [ 3, 0.16667, 0.02608]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ -0.62736, [ 3, -0.33333, 0.11965], [ 3, 0.16667, -0.05983]], [ -1.06609, [ 3, -0.16667, 0.11403], [ 3, 0.16667, -0.11403]], [ -1.31153, [ 3, -0.16667, 0.05395], [ 3, 0.16667, -0.05395]], [ -1.38976, [ 3, -0.16667, 0.02736], [ 3, 0.16667, -0.02736]], [ -1.47567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.35755, [ 3, -0.16667, -0.11300], [ 3, 0.16667, 0.11300]], [ -0.79764, [ 3, -0.16667, -0.12962], [ 3, 0.16667, 0.12962]], [ -0.57981, [ 3, -0.16667, -0.04832], [ 3, 0.16667, 0.04832]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ -1.21037, [ 3, -0.33333, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.21037, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.16895, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.49416, [ 3, -0.16667, -0.03040], [ 3, 0.16667, 0.03040]], [ -1.36223, [ 3, -0.16667, -0.03758], [ 3, 0.16667, 0.03758]], [ -1.26866, [ 3, -0.16667, -0.02633], [ 3, 0.16667, 0.02633]], [ -1.20423, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ -0.08586, [ 3, -0.33333, 0.28226], [ 3, 0.16667, -0.14113]], [ -1.07069, [ 3, -0.16667, 0.22448], [ 3, 0.16667, -0.22448]], [ -1.43271, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.22409, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.23023, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.05382, [ 3, -0.16667, -0.13755], [ 3, 0.16667, 0.13755]], [ -0.40493, [ 3, -0.16667, -0.20811], [ 3, 0.16667, 0.20811]], [ 0.19486, [ 3, -0.16667, -0.00460], [ 3, 0.16667, 0.00460]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LHand")
    times.append([ 0.50000, 2.50000, 3.00000, 3.50000, 4.00000, 5.00000, 5.50000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]], [ 0.01745, [ 3, -0.66667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.97280, [ 3, -0.33333, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.89735, [ 3, -0.33333, 0.02608], [ 3, 0.16667, -0.01304]], [ 0.71020, [ 3, -0.16667, 0.04116], [ 3, 0.16667, -0.04116]], [ 0.65037, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65958, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65958, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65037, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65037, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97712, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ -0.19478, [ 3, -0.33333, -0.01704], [ 3, 0.16667, 0.00852]], [ -0.16870, [ 3, -0.16667, -0.00946], [ 3, 0.16667, 0.00946]], [ -0.13802, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.13802, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.13955, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.13955, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.14262, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.64125, [ 3, -0.33333, -0.12545], [ 3, 0.16667, 0.06272]], [ 1.00481, [ 3, -0.16667, -0.04909], [ 3, 0.16667, 0.04909]], [ 1.05390, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04163, [ 3, -0.16667, 0.00409], [ 3, 0.16667, -0.00409]], [ 1.02936, [ 3, -0.16667, 0.00716], [ 3, 0.16667, -0.00716]], [ 0.99868, [ 3, -0.16667, 0.02787], [ 3, 0.16667, -0.02787]], [ 0.86215, [ 3, -0.16667, 0.06698], [ 3, 0.16667, -0.06698]], [ 0.59677, [ 3, -0.16667, 0.07031], [ 3, 0.16667, -0.07031]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 1.31920, [ 3, -0.33333, -0.00307], [ 3, 0.16667, 0.00153]], [ 1.32073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31920, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.30999, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31460, [ 3, -0.16667, -0.00179], [ 3, 0.16667, 0.00179]], [ 1.32073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31766, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 1.29926, [ 3, -0.16667, 0.00486], [ 3, 0.16667, -0.00486]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.16418, [ 3, -0.33333, -0.18340], [ 3, 0.16667, 0.09170]], [ 0.54308, [ 3, -0.16667, -0.07926], [ 3, 0.16667, 0.07926]], [ 0.63972, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.63972, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.63972, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.53234, [ 3, -0.16667, 0.04091], [ 3, 0.16667, -0.04091]], [ 0.39428, [ 3, -0.16667, 0.09562], [ 3, 0.16667, -0.09562]], [ -0.04138, [ 3, -0.16667, 0.11275], [ 3, 0.16667, -0.11275]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("OhYesLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def OhYesRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.89735, [ 3, -0.33333, 0.02608], [ 3, 0.16667, -0.01304]], [ 0.71020, [ 3, -0.16667, 0.04116], [ 3, 0.16667, -0.04116]], [ 0.65037, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65958, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65958, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65037, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.65037, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97712, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.19478, [ 3, -0.33333, 0.01704], [ 3, 0.16667, -0.00852]], [ 0.16870, [ 3, -0.16667, 0.00946], [ 3, 0.16667, -0.00946]], [ 0.13802, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.13802, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.13955, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.13955, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.14262, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ -0.64125, [ 3, -0.33333, 0.12545], [ 3, 0.16667, -0.06272]], [ -1.00481, [ 3, -0.16667, 0.04909], [ 3, 0.16667, -0.04909]], [ -1.05390, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.04163, [ 3, -0.16667, -0.00409], [ 3, 0.16667, 0.00409]], [ -1.02936, [ 3, -0.16667, -0.00716], [ 3, 0.16667, 0.00716]], [ -0.99868, [ 3, -0.16667, -0.02787], [ 3, 0.16667, 0.02787]], [ -0.86215, [ 3, -0.16667, -0.06698], [ 3, 0.16667, 0.06698]], [ -0.59677, [ 3, -0.16667, -0.07031], [ 3, 0.16667, 0.07031]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ -1.31920, [ 3, -0.33333, 0.00307], [ 3, 0.16667, -0.00153]], [ -1.32073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31920, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.30999, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31460, [ 3, -0.16667, 0.00179], [ 3, 0.16667, -0.00179]], [ -1.32073, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31766, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -1.29926, [ 3, -0.16667, -0.00486], [ 3, 0.16667, 0.00486]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ -0.16418, [ 3, -0.33333, 0.18340], [ 3, 0.16667, -0.09170]], [ -0.54308, [ 3, -0.16667, 0.07926], [ 3, 0.16667, -0.07926]], [ -0.63972, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.63972, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.63972, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.53234, [ 3, -0.16667, -0.04091], [ 3, 0.16667, 0.04091]], [ -0.39428, [ 3, -0.16667, -0.09562], [ 3, 0.16667, 0.09562]], [ 0.04138, [ 3, -0.16667, -0.11275], [ 3, 0.16667, 0.11275]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.83761, [ 3, -0.33333, 0.11352], [ 3, 0.16667, -0.05676]], [ 0.09822, [ 3, -0.16667, 0.15391], [ 3, 0.16667, -0.15391]], [ -0.08586, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.58756, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23168, [ 3, -0.16667, 0.06443], [ 3, 0.16667, -0.06443]], [ 0.16725, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.39121, [ 3, -0.16667, -0.12349], [ 3, 0.16667, 0.12349]], [ 0.90817, [ 3, -0.16667, -0.04295], [ 3, 0.16667, 0.04295]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ -0.16725, [ 3, -0.33333, -0.01534], [ 3, 0.16667, 0.00767]], [ -0.15958, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.15804, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.09055, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09515, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09362, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.11816, [ 3, -0.16667, 0.00869], [ 3, 0.16667, -0.00869]], [ -0.14577, [ 3, -0.16667, 0.02608], [ 3, 0.16667, -0.02608]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.62736, [ 3, -0.33333, -0.11965], [ 3, 0.16667, 0.05983]], [ 1.06609, [ 3, -0.16667, -0.11403], [ 3, 0.16667, 0.11403]], [ 1.31153, [ 3, -0.16667, -0.05395], [ 3, 0.16667, 0.05395]], [ 1.38976, [ 3, -0.16667, -0.02736], [ 3, 0.16667, 0.02736]], [ 1.47567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.35755, [ 3, -0.16667, 0.11300], [ 3, 0.16667, -0.11300]], [ 0.79764, [ 3, -0.16667, 0.12962], [ 3, 0.16667, -0.12962]], [ 0.57981, [ 3, -0.16667, 0.04832], [ 3, 0.16667, -0.04832]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 1.21037, [ 3, -0.33333, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.21037, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.16895, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.49416, [ 3, -0.16667, 0.03040], [ 3, 0.16667, -0.03040]], [ 1.36223, [ 3, -0.16667, 0.03758], [ 3, 0.16667, -0.03758]], [ 1.26866, [ 3, -0.16667, 0.02633], [ 3, 0.16667, -0.02633]], [ 1.20423, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.08586, [ 3, -0.33333, -0.28226], [ 3, 0.16667, 0.14113]], [ 1.07069, [ 3, -0.16667, -0.22448], [ 3, 0.16667, 0.22448]], [ 1.43271, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.22409, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.23023, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.05382, [ 3, -0.16667, 0.13755], [ 3, 0.16667, -0.13755]], [ 0.40493, [ 3, -0.16667, 0.20811], [ 3, 0.16667, -0.20811]], [ -0.19486, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RHand")
    times.append([ 0.50000, 2.50000, 3.00000, 3.50000, 4.00000, 5.00000, 5.50000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.66667, 0.00000]], [ 0.01745, [ 3, -0.66667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.33333, 0.00000]], [ 0.97280, [ 3, -0.33333, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("OhYesRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PalmUp():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94644, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.94797, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94797, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97251, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ 1.00319, [ 3, -0.16667, -0.00741], [ 3, 0.16667, 0.00741]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98172, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98172, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27301, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.45411, [ 3, -0.16667, 0.01381], [ 3, 0.16667, -0.01381]], [ -0.68574, [ 3, -0.16667, 0.08693], [ 3, 0.16667, -0.08693]], [ -0.97567, [ 3, -0.16667, 0.09971], [ 3, 0.16667, -0.09971]], [ -1.28400, [ 3, -0.16667, 0.09536], [ 3, 0.16667, -0.09536]], [ -1.54785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.38064, [ 3, -0.16667, -0.10099], [ 3, 0.16667, 0.10099]], [ -0.94192, [ 3, -0.16667, -0.14445], [ 3, 0.16667, 0.14445]], [ -0.51393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.51393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.27471, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -1.27318, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -1.27164, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30232, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29926, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -1.28392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25153, [ 3, -0.16667, 0.03068], [ 3, 0.16667, -0.03068]], [ -0.05680, [ 3, -0.16667, 0.10176], [ 3, 0.16667, -0.10176]], [ -0.35900, [ 3, -0.16667, 0.11684], [ 3, 0.16667, -0.11684]], [ -0.75784, [ 3, -0.16667, 0.10022], [ 3, 0.16667, -0.10022]], [ -0.96033, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.88823, [ 3, -0.16667, -0.07210], [ 3, 0.16667, 0.07210]], [ -0.25008, [ 3, -0.16667, -0.20095], [ 3, 0.16667, 0.20095]], [ 0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94644, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94797, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94797, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97251, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ 1.00319, [ 3, -0.16667, -0.00741], [ 3, 0.16667, 0.00741]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98172, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98172, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27301, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.45410, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.68574, [ 3, -0.16667, -0.08693], [ 3, 0.16667, 0.08693]], [ 0.97567, [ 3, -0.16667, -0.09971], [ 3, 0.16667, 0.09971]], [ 1.28400, [ 3, -0.16667, -0.09536], [ 3, 0.16667, 0.09536]], [ 1.54785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.38064, [ 3, -0.16667, 0.10099], [ 3, 0.16667, -0.10099]], [ 0.94192, [ 3, -0.16667, 0.14445], [ 3, 0.16667, -0.14445]], [ 0.51393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.51393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.27471, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 1.27318, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 1.27164, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30232, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29926, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 1.28392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25153, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.05680, [ 3, -0.16667, -0.10176], [ 3, 0.16667, 0.10176]], [ 0.35900, [ 3, -0.16667, -0.11684], [ 3, 0.16667, 0.11684]], [ 0.75784, [ 3, -0.16667, -0.10022], [ 3, 0.16667, 0.10022]], [ 0.96033, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88823, [ 3, -0.16667, 0.07210], [ 3, 0.16667, -0.07210]], [ 0.25008, [ 3, -0.16667, 0.20095], [ 3, 0.16667, -0.20095]], [ -0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PalmUp")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PalmUpLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94644, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.94797, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94797, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97251, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ 1.00319, [ 3, -0.16667, -0.00741], [ 3, 0.16667, 0.00741]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98172, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98172, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27301, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.45410, [ 3, -0.16667, 0.01381], [ 3, 0.16667, -0.01381]], [ -0.68574, [ 3, -0.16667, 0.08693], [ 3, 0.16667, -0.08693]], [ -0.97567, [ 3, -0.16667, 0.09971], [ 3, 0.16667, -0.09971]], [ -1.28400, [ 3, -0.16667, 0.09536], [ 3, 0.16667, -0.09536]], [ -1.54785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.38064, [ 3, -0.16667, -0.10099], [ 3, 0.16667, 0.10099]], [ -0.94192, [ 3, -0.16667, -0.14445], [ 3, 0.16667, 0.14445]], [ -0.51393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.51393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.27471, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -1.27318, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -1.27164, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30232, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29926, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -1.28392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25153, [ 3, -0.16667, 0.03068], [ 3, 0.16667, -0.03068]], [ -0.05680, [ 3, -0.16667, 0.10176], [ 3, 0.16667, -0.10176]], [ -0.35900, [ 3, -0.16667, 0.11684], [ 3, 0.16667, -0.11684]], [ -0.75784, [ 3, -0.16667, 0.10022], [ 3, 0.16667, -0.10022]], [ -0.96033, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.88823, [ 3, -0.16667, -0.07210], [ 3, 0.16667, 0.07210]], [ -0.25008, [ 3, -0.16667, -0.20095], [ 3, 0.16667, 0.20095]], [ 0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.02629, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.02475, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28843, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28690, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28843, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28537, [ 3, -0.16667, -0.00179], [ 3, 0.16667, 0.00179]], [ -0.27770, [ 3, -0.16667, -0.00179], [ 3, 0.16667, 0.00179]], [ -0.27463, [ 3, -0.16667, -0.00256], [ 3, 0.16667, 0.00256]], [ -0.26236, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27156, [ 3, -0.16667, 0.00435], [ 3, 0.16667, -0.00435]], [ -0.28843, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.51538, [ 3, -0.16667, -0.00767], [ 3, 0.16667, 0.00767]], [ 0.58595, [ 3, -0.16667, -0.03963], [ 3, 0.16667, 0.03963]], [ 0.75315, [ 3, -0.16667, -0.03656], [ 3, 0.16667, 0.03656]], [ 0.80531, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.80377, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.80377, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.78230, [ 3, -0.16667, 0.00972], [ 3, 0.16667, -0.00972]], [ 0.74548, [ 3, -0.16667, 0.01969], [ 3, 0.16667, -0.01969]], [ 0.66418, [ 3, -0.16667, 0.03963], [ 3, 0.16667, -0.03963]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28707, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28860, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ 1.29014, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28860, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28860, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29014, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ 1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, -0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21634, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.05373, [ 3, -0.16667, -0.09818], [ 3, 0.16667, 0.09818]], [ 0.37272, [ 3, -0.16667, -0.08565], [ 3, 0.16667, 0.08565]], [ 0.46016, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.45709, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.34051, [ 3, -0.16667, 0.02787], [ 3, 0.16667, -0.02787]], [ 0.28988, [ 3, -0.16667, 0.05062], [ 3, 0.16667, -0.05062]], [ -0.16878, [ 3, -0.16667, 0.05983], [ 3, 0.16667, -0.05983]], [ -0.22861, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PalmUpLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PalmUpRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97567, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.02629, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.02475, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28843, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28690, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28843, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28537, [ 3, -0.16667, 0.00179], [ 3, 0.16667, -0.00179]], [ 0.27770, [ 3, -0.16667, 0.00179], [ 3, 0.16667, -0.00179]], [ 0.27463, [ 3, -0.16667, 0.00256], [ 3, 0.16667, -0.00256]], [ 0.26236, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27156, [ 3, -0.16667, -0.00435], [ 3, 0.16667, 0.00435]], [ 0.28843, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.51538, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ -0.58595, [ 3, -0.16667, 0.03963], [ 3, 0.16667, -0.03963]], [ -0.75315, [ 3, -0.16667, 0.03656], [ 3, 0.16667, -0.03656]], [ -0.80531, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.80377, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.80377, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.78230, [ 3, -0.16667, -0.00972], [ 3, 0.16667, 0.00972]], [ -0.74548, [ 3, -0.16667, -0.01969], [ 3, 0.16667, 0.01969]], [ -0.66418, [ 3, -0.16667, -0.03963], [ 3, 0.16667, 0.03963]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28707, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28860, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ -1.29014, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28860, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28860, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29014, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ -1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21634, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.05373, [ 3, -0.16667, 0.09818], [ 3, 0.16667, -0.09818]], [ -0.37272, [ 3, -0.16667, 0.08565], [ 3, 0.16667, -0.08565]], [ -0.46016, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.45709, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.34051, [ 3, -0.16667, -0.02787], [ 3, 0.16667, 0.02787]], [ -0.28988, [ 3, -0.16667, -0.05062], [ 3, 0.16667, 0.05062]], [ 0.16878, [ 3, -0.16667, -0.05983], [ 3, 0.16667, 0.05983]], [ 0.22861, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94644, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.94797, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94797, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97251, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ 1.00319, [ 3, -0.16667, -0.00741], [ 3, 0.16667, 0.00741]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01700, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98172, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98172, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26841, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27301, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.45410, [ 3, -0.16667, -0.01381], [ 3, 0.16667, 0.01381]], [ 0.68574, [ 3, -0.16667, -0.08693], [ 3, 0.16667, 0.08693]], [ 0.97567, [ 3, -0.16667, -0.09971], [ 3, 0.16667, 0.09971]], [ 1.28400, [ 3, -0.16667, -0.09536], [ 3, 0.16667, 0.09536]], [ 1.54785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.38064, [ 3, -0.16667, 0.10099], [ 3, 0.16667, -0.10099]], [ 0.94192, [ 3, -0.16667, 0.14445], [ 3, 0.16667, -0.14445]], [ 0.51393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.51393, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.27471, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 1.27318, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 1.27164, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30232, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29926, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 1.28392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28392, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000])
    keys.append([ [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25153, [ 3, -0.16667, -0.03068], [ 3, 0.16667, 0.03068]], [ 0.05680, [ 3, -0.16667, -0.10176], [ 3, 0.16667, 0.10176]], [ 0.35900, [ 3, -0.16667, -0.11684], [ 3, 0.16667, 0.11684]], [ 0.75784, [ 3, -0.16667, -0.10022], [ 3, 0.16667, 0.10022]], [ 0.96033, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88823, [ 3, -0.16667, 0.07210], [ 3, 0.16667, -0.07210]], [ 0.25008, [ 3, -0.16667, 0.20095], [ 3, 0.16667, -0.20095]], [ -0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.31750, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PalmUpRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PointMyself():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87894, [ 3, -0.16667, 0.01483], [ 3, 0.16667, -0.01483]], [ 0.83445, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.82678, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, -0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.81306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.81306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86360, [ 3, -0.16667, -0.02862], [ 3, 0.16667, 0.02862]], [ 0.98479, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21165, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.21012, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35738, [ 3, -0.16667, -0.03503], [ 3, 0.16667, 0.03503]], [ 0.42027, [ 3, -0.16667, -0.01739], [ 3, 0.16667, 0.01739]], [ 0.46169, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.43263, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46169, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.43263, [ 3, -0.16667, 0.00588], [ 3, 0.16667, -0.00588]], [ 0.42641, [ 3, -0.16667, 0.00385], [ 3, 0.16667, -0.00385]], [ 0.40954, [ 3, -0.16667, 0.01687], [ 3, 0.16667, -0.01687]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.82533, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.80846, [ 3, -0.16667, -0.01355], [ 3, 0.16667, 0.01355]], [ -0.74403, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.75170, [ 3, -0.16667, 0.00205], [ 3, 0.16667, -0.00205]], [ -0.75630, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.73168, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.75630, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.73168, [ 3, -0.16667, -0.02463], [ 3, 0.16667, 0.02463]], [ -0.57529, [ 3, -0.16667, -0.04703], [ 3, 0.16667, 0.04703]], [ -0.44950, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32994, [ 3, -0.16667, 0.04142], [ 3, 0.16667, -0.04142]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, -0.00000], [ 3, 0.16667, 0.00000]], [ -1.45266, [ 3, -0.16667, -0.04268], [ 3, 0.16667, 0.04268]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26696, [ 3, -0.16667, 0.04602], [ 3, 0.16667, -0.04602]], [ -0.31298, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.31451, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.75937, [ 3, -0.16667, 0.09511], [ 3, 0.16667, -0.09511]], [ -0.88516, [ 3, -0.16667, 0.07124], [ 3, 0.16667, -0.07124]], [ -1.18682, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.18682, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.00763, [ 3, -0.16667, -0.26657], [ 3, 0.16667, 0.26657]], [ 0.41260, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.90510, [ 3, -0.16667, 0.01278], [ 3, 0.16667, -0.01278]], [ 0.87442, [ 3, -0.16667, 0.01636], [ 3, 0.16667, -0.01636]], [ 0.80693, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.80999, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ 0.81306, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.81306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, -0.01074], [ 3, 0.16667, 0.01074]], [ 0.87749, [ 3, -0.16667, -0.02405], [ 3, 0.16667, 0.02405]], [ 0.97873, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23474, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25008, [ 3, -0.16667, 0.01534], [ 3, 0.16667, -0.01534]], [ -0.38661, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ -0.39581, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ -0.43263, [ 3, -0.16667, 0.01098], [ 3, 0.16667, -0.01098]], [ -0.46169, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.43263, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46169, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.38201, [ 3, -0.16667, -0.00460], [ 3, 0.16667, 0.00460]], [ -0.37741, [ 3, -0.16667, -0.00460], [ 3, 0.16667, 0.00460]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84212, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84059, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.68412, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.69793, [ 3, -0.16667, -0.00793], [ 3, 0.16667, 0.00793]], [ 0.73168, [ 3, -0.16667, -0.00973], [ 3, 0.16667, 0.00973]], [ 0.75630, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.73168, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.75630, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.57367, [ 3, -0.16667, 0.05012], [ 3, 0.16667, -0.05012]], [ 0.45556, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.42206, [ 3, -0.16667, -0.03986], [ 3, 0.16667, 0.03986]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54171, [ 3, -0.16667, 0.00290], [ 3, 0.16667, -0.00290]], [ 1.44047, [ 3, -0.16667, 0.03937], [ 3, 0.16667, -0.03937]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.42794, [ 3, -0.16667, -0.05522], [ 3, 0.16667, 0.05522]], [ 0.48317, [ 3, -0.16667, -0.02173], [ 3, 0.16667, 0.02173]], [ 0.55833, [ 3, -0.16667, -0.05599], [ 3, 0.16667, 0.05599]], [ 0.81911, [ 3, -0.16667, -0.10475], [ 3, 0.16667, 0.10475]], [ 1.18682, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.18682, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88516, [ 3, -0.16667, 0.18912], [ 3, 0.16667, -0.18912]], [ 0.05211, [ 3, -0.16667, 0.19074], [ 3, 0.16667, -0.19074]], [ -0.25929, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PointMyself")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PointMyselfLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87894, [ 3, -0.16667, 0.01483], [ 3, 0.16667, -0.01483]], [ 0.83445, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.82678, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.81306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.81306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86360, [ 3, -0.16667, -0.02862], [ 3, 0.16667, 0.02862]], [ 0.98479, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21165, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.21012, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35738, [ 3, -0.16667, -0.03503], [ 3, 0.16667, 0.03503]], [ 0.42027, [ 3, -0.16667, -0.01739], [ 3, 0.16667, 0.01739]], [ 0.46169, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.43263, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46169, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.43263, [ 3, -0.16667, 0.00588], [ 3, 0.16667, -0.00588]], [ 0.42641, [ 3, -0.16667, 0.00385], [ 3, 0.16667, -0.00385]], [ 0.40954, [ 3, -0.16667, 0.01687], [ 3, 0.16667, -0.01687]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.82533, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.80846, [ 3, -0.16667, -0.01355], [ 3, 0.16667, 0.01355]], [ -0.74403, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.75170, [ 3, -0.16667, 0.00205], [ 3, 0.16667, -0.00205]], [ -0.75630, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.73168, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.75630, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.73168, [ 3, -0.16667, -0.02463], [ 3, 0.16667, 0.02463]], [ -0.57529, [ 3, -0.16667, -0.04703], [ 3, 0.16667, 0.04703]], [ -0.44950, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32994, [ 3, -0.16667, 0.04142], [ 3, 0.16667, -0.04142]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.45266, [ 3, -0.16667, -0.04268], [ 3, 0.16667, 0.04268]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26696, [ 3, -0.16667, 0.04602], [ 3, 0.16667, -0.04602]], [ -0.31298, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.31451, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.75937, [ 3, -0.16667, 0.09511], [ 3, 0.16667, -0.09511]], [ -0.88516, [ 3, -0.16667, 0.07124], [ 3, 0.16667, -0.07124]], [ -1.18682, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.18682, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.00763, [ 3, -0.16667, -0.26657], [ 3, 0.16667, 0.26657]], [ 0.41260, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99407, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99407, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.30224, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.30224, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27770, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28997, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.30071, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.30071, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.30071, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, -0.00000]], [ 0.50618, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.56294, [ 3, -0.16667, -0.02787], [ 3, 0.16667, 0.02787]], [ 0.67338, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.64731, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.67338, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.62583, [ 3, -0.16667, 0.02148], [ 3, 0.16667, -0.02148]], [ 0.54453, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.54453, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.54453, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31315, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.31468, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30701, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31315, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.31161, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20713, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.20867, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.01078, [ 3, -0.16667, -0.05752], [ 3, 0.16667, 0.05752]], [ 0.13648, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.08586, [ 3, -0.16667, 0.03119], [ 3, 0.16667, -0.03119]], [ -0.05066, [ 3, -0.16667, 0.02889], [ 3, 0.16667, -0.02889]], [ -0.08748, [ 3, -0.16667, 0.03682], [ 3, 0.16667, -0.03682]], [ -0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PointMyselfLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PointMyselfRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97720, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99407, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99407, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.30224, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.30224, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27770, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28997, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.30071, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.30071, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.30071, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50618, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.56294, [ 3, -0.16667, 0.02787], [ 3, 0.16667, -0.02787]], [ -0.67338, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.64731, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.67338, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.62583, [ 3, -0.16667, -0.02148], [ 3, 0.16667, 0.02148]], [ -0.54453, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.54453, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.54453, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31315, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.31468, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30701, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31315, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.31161, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30854, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20713, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.20867, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01078, [ 3, -0.16667, 0.05753], [ 3, 0.16667, -0.05753]], [ -0.13648, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.08586, [ 3, -0.16667, -0.03119], [ 3, 0.16667, 0.03119]], [ 0.05066, [ 3, -0.16667, -0.02889], [ 3, 0.16667, 0.02889]], [ 0.08748, [ 3, -0.16667, -0.03682], [ 3, 0.16667, 0.03682]], [ 0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27616, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87894, [ 3, -0.16667, 0.01483], [ 3, 0.16667, -0.01483]], [ 0.83445, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.82678, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.81306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.83445, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.81306, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86360, [ 3, -0.16667, -0.02862], [ 3, 0.16667, 0.02862]], [ 0.98479, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21165, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.21012, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35738, [ 3, -0.16667, 0.03503], [ 3, 0.16667, -0.03503]], [ -0.42027, [ 3, -0.16667, 0.01739], [ 3, 0.16667, -0.01739]], [ -0.46169, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.43263, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46169, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.43263, [ 3, -0.16667, -0.00588], [ 3, 0.16667, 0.00588]], [ -0.42641, [ 3, -0.16667, -0.00385], [ 3, 0.16667, 0.00385]], [ -0.40954, [ 3, -0.16667, -0.01687], [ 3, 0.16667, 0.01687]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.82533, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.80846, [ 3, -0.16667, 0.01355], [ 3, 0.16667, -0.01355]], [ 0.74403, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.75170, [ 3, -0.16667, -0.00205], [ 3, 0.16667, 0.00205]], [ 0.75630, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.73168, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.75630, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.73168, [ 3, -0.16667, 0.02463], [ 3, 0.16667, -0.02463]], [ 0.57529, [ 3, -0.16667, 0.04703], [ 3, 0.16667, -0.04703]], [ 0.44950, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32994, [ 3, -0.16667, -0.04142], [ 3, 0.16667, 0.04142]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.45266, [ 3, -0.16667, 0.04268], [ 3, 0.16667, -0.04268]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26696, [ 3, -0.16667, -0.04602], [ 3, 0.16667, 0.04602]], [ 0.31298, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.31451, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.75937, [ 3, -0.16667, -0.09511], [ 3, 0.16667, 0.09511]], [ 0.88516, [ 3, -0.16667, -0.07124], [ 3, 0.16667, 0.07124]], [ 1.18682, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.18682, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.00763, [ 3, -0.16667, 0.26657], [ 3, 0.16667, -0.26657]], [ -0.41260, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PointMyselfRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PointYou():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94192, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.85908, [ 3, -0.16667, 0.02199], [ 3, 0.16667, -0.02199]], [ 0.80999, [ 3, -0.16667, 0.01994], [ 3, 0.16667, -0.01994]], [ 0.73943, [ 3, -0.16667, 0.05216], [ 3, 0.16667, -0.05216]], [ 0.49706, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.48785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.48785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.61518, [ 3, -0.16667, -0.03809], [ 3, 0.16667, 0.03809]], [ 0.71642, [ 3, -0.16667, -0.02557], [ 3, 0.16667, 0.02557]], [ 0.76858, [ 3, -0.16667, -0.03912], [ 3, 0.16667, 0.03912]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23321, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23321, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.17492, [ 3, -0.16667, 0.03017], [ 3, 0.16667, -0.03017]], [ 0.05220, [ 3, -0.16667, 0.04244], [ 3, 0.16667, -0.04244]], [ -0.07973, [ 3, -0.16667, 0.03579], [ 3, 0.16667, -0.03579]], [ -0.16256, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.16103, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.12421, [ 3, -0.16667, -0.01969], [ 3, 0.16667, 0.01969]], [ -0.04291, [ 3, -0.16667, -0.03886], [ 3, 0.16667, 0.03886]], [ 0.10896, [ 3, -0.16667, -0.05292], [ 3, 0.16667, 0.05292]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.64270, [ 3, -0.16667, 0.06162], [ 3, 0.16667, -0.06162]], [ -0.87741, [ 3, -0.16667, 0.07849], [ 3, 0.16667, -0.07849]], [ -1.11364, [ 3, -0.16667, 0.06034], [ 3, 0.16667, -0.06034]], [ -1.23943, [ 3, -0.16667, 0.02531], [ 3, 0.16667, -0.02531]], [ -1.26551, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ -1.28545, [ 3, -0.16667, 0.00537], [ 3, 0.16667, -0.00537]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.26858, [ 3, -0.16667, -0.02915], [ 3, 0.16667, 0.02915]], [ -0.68872, [ 3, -0.16667, -0.12707], [ 3, 0.16667, 0.12707]], [ -0.50618, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.26252, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.26099, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.23645, [ 3, -0.16667, -0.02454], [ 3, 0.16667, 0.02454]], [ -1.04930, [ 3, -0.16667, -0.10124], [ 3, 0.16667, 0.10124]], [ -0.62898, [ 3, -0.16667, -0.02915], [ 3, 0.16667, 0.02915]], [ -0.59984, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.59984, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.62131, [ 3, -0.16667, 0.02147], [ 3, 0.16667, -0.02147]], [ -0.74710, [ 3, -0.16667, 0.05522], [ 3, 0.16667, -0.05522]], [ -0.95266, [ 3, -0.16667, 0.09306], [ 3, 0.16667, -0.09306]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.02143, [ 3, -0.16667, 0.15314], [ 3, 0.16667, -0.15314]], [ -0.71940, [ 3, -0.16667, 0.15749], [ 3, 0.16667, -0.15749]], [ -0.96638, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -0.96945, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.07069, [ 3, -0.16667, 0.05062], [ 3, 0.16667, -0.05062]], [ -1.27318, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36505, [ 3, -0.16667, -0.08284], [ 3, 0.16667, 0.08284]], [ -0.28221, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.27915, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94192, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.85908, [ 3, -0.16667, 0.02199], [ 3, 0.16667, -0.02199]], [ 0.80999, [ 3, -0.16667, 0.01994], [ 3, 0.16667, -0.01994]], [ 0.73943, [ 3, -0.16667, 0.05216], [ 3, 0.16667, -0.05216]], [ 0.49706, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.48785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.48785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.61518, [ 3, -0.16667, -0.03809], [ 3, 0.16667, 0.03809]], [ 0.71642, [ 3, -0.16667, -0.02557], [ 3, 0.16667, 0.02557]], [ 0.76858, [ 3, -0.16667, -0.03912], [ 3, 0.16667, 0.03912]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23321, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23321, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.17492, [ 3, -0.16667, -0.03017], [ 3, 0.16667, 0.03017]], [ -0.05220, [ 3, -0.16667, -0.04244], [ 3, 0.16667, 0.04244]], [ 0.07973, [ 3, -0.16667, -0.03579], [ 3, 0.16667, 0.03579]], [ 0.16256, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.16103, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.12421, [ 3, -0.16667, 0.01969], [ 3, 0.16667, -0.01969]], [ 0.04291, [ 3, -0.16667, 0.03886], [ 3, 0.16667, -0.03886]], [ -0.10896, [ 3, -0.16667, 0.05292], [ 3, 0.16667, -0.05292]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.64270, [ 3, -0.16667, -0.06162], [ 3, 0.16667, 0.06162]], [ 0.87741, [ 3, -0.16667, -0.07849], [ 3, 0.16667, 0.07849]], [ 1.11364, [ 3, -0.16667, -0.06034], [ 3, 0.16667, 0.06034]], [ 1.23943, [ 3, -0.16667, -0.02531], [ 3, 0.16667, 0.02531]], [ 1.26551, [ 3, -0.16667, -0.00767], [ 3, 0.16667, 0.00767]], [ 1.28545, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.26858, [ 3, -0.16667, 0.02915], [ 3, 0.16667, -0.02915]], [ 0.68872, [ 3, -0.16667, 0.12707], [ 3, 0.16667, -0.12707]], [ 0.50618, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.26252, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.26099, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.23645, [ 3, -0.16667, 0.02454], [ 3, 0.16667, -0.02454]], [ 1.04930, [ 3, -0.16667, 0.10124], [ 3, 0.16667, -0.10124]], [ 0.62898, [ 3, -0.16667, 0.02915], [ 3, 0.16667, -0.02915]], [ 0.59984, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.59984, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.62131, [ 3, -0.16667, -0.02148], [ 3, 0.16667, 0.02148]], [ 0.74710, [ 3, -0.16667, -0.05522], [ 3, 0.16667, 0.05522]], [ 0.95266, [ 3, -0.16667, -0.09306], [ 3, 0.16667, 0.09306]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.02143, [ 3, -0.16667, -0.15314], [ 3, 0.16667, 0.15314]], [ 0.71940, [ 3, -0.16667, -0.15749], [ 3, 0.16667, 0.15749]], [ 0.96638, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.96945, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.07069, [ 3, -0.16667, -0.05062], [ 3, 0.16667, 0.05062]], [ 1.27318, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36505, [ 3, -0.16667, 0.08284], [ 3, 0.16667, -0.08284]], [ 0.28221, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.27915, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PointYou")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PointYouLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94192, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.85908, [ 3, -0.16667, 0.02199], [ 3, 0.16667, -0.02199]], [ 0.80999, [ 3, -0.16667, 0.01994], [ 3, 0.16667, -0.01994]], [ 0.73943, [ 3, -0.16667, 0.05216], [ 3, 0.16667, -0.05216]], [ 0.49706, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.48785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.48785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.61518, [ 3, -0.16667, -0.03809], [ 3, 0.16667, 0.03809]], [ 0.71642, [ 3, -0.16667, -0.02557], [ 3, 0.16667, 0.02557]], [ 0.76858, [ 3, -0.16667, -0.03912], [ 3, 0.16667, 0.03912]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23321, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23321, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.17492, [ 3, -0.16667, 0.03017], [ 3, 0.16667, -0.03017]], [ 0.05220, [ 3, -0.16667, 0.04244], [ 3, 0.16667, -0.04244]], [ -0.07973, [ 3, -0.16667, 0.03579], [ 3, 0.16667, -0.03579]], [ -0.16256, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.16103, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.12421, [ 3, -0.16667, -0.01969], [ 3, 0.16667, 0.01969]], [ -0.04291, [ 3, -0.16667, -0.03886], [ 3, 0.16667, 0.03886]], [ 0.10896, [ 3, -0.16667, -0.05292], [ 3, 0.16667, 0.05292]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.64270, [ 3, -0.16667, 0.06162], [ 3, 0.16667, -0.06162]], [ -0.87741, [ 3, -0.16667, 0.07849], [ 3, 0.16667, -0.07849]], [ -1.11364, [ 3, -0.16667, 0.06034], [ 3, 0.16667, -0.06034]], [ -1.23943, [ 3, -0.16667, 0.02531], [ 3, 0.16667, -0.02531]], [ -1.26551, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ -1.28545, [ 3, -0.16667, 0.00537], [ 3, 0.16667, -0.00537]], [ -1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.26858, [ 3, -0.16667, -0.02915], [ 3, 0.16667, 0.02915]], [ -0.68872, [ 3, -0.16667, -0.12707], [ 3, 0.16667, 0.12707]], [ -0.50618, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.26252, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.26099, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.23645, [ 3, -0.16667, -0.02454], [ 3, 0.16667, 0.02454]], [ -1.04930, [ 3, -0.16667, -0.10124], [ 3, 0.16667, 0.10124]], [ -0.62898, [ 3, -0.16667, -0.02915], [ 3, 0.16667, 0.02915]], [ -0.59984, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.59984, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.62131, [ 3, -0.16667, 0.02147], [ 3, 0.16667, -0.02147]], [ -0.74710, [ 3, -0.16667, 0.05522], [ 3, 0.16667, -0.05522]], [ -0.95266, [ 3, -0.16667, 0.09306], [ 3, 0.16667, -0.09306]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.02143, [ 3, -0.16667, 0.15314], [ 3, 0.16667, -0.15314]], [ -0.71940, [ 3, -0.16667, 0.15749], [ 3, 0.16667, -0.15749]], [ -0.96638, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -0.96945, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.07069, [ 3, -0.16667, 0.05062], [ 3, 0.16667, -0.05062]], [ -1.27318, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36505, [ 3, -0.16667, -0.08284], [ 3, 0.16667, 0.08284]], [ -0.28221, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.27915, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.02015, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01402, [ 3, -0.16667, 0.00614], [ 3, 0.16667, -0.00614]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27156, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.26849, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.26542, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.49391, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.54453, [ 3, -0.16667, -0.03298], [ 3, 0.16667, 0.03298]], [ 0.69179, [ 3, -0.16667, -0.05420], [ 3, 0.16667, 0.05420]], [ 0.86974, [ 3, -0.16667, -0.04679], [ 3, 0.16667, 0.04679]], [ 0.97251, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.97558, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ 0.98018, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.92803, [ 3, -0.16667, 0.02557], [ 3, 0.16667, -0.02557]], [ 0.82678, [ 3, -0.16667, 0.05113], [ 3, 0.16667, -0.05113]], [ 0.62123, [ 3, -0.16667, 0.05318], [ 3, 0.16667, -0.05318]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29781, [ 3, -0.16667, 0.00230], [ 3, 0.16667, -0.00230]], [ 1.29167, [ 3, -0.16667, 0.00179], [ 3, 0.16667, -0.00179]], [ 1.28707, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 1.28553, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28553, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28553, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28247, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28553, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20100, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.14577, [ 3, -0.16667, -0.05522], [ 3, 0.16667, 0.05522]], [ 0.17177, [ 3, -0.16667, -0.05983], [ 3, 0.16667, 0.05983]], [ 0.23159, [ 3, -0.16667, -0.01636], [ 3, 0.16667, 0.01636]], [ 0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.45402, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.31289, [ 3, -0.16667, 0.08590], [ 3, 0.16667, -0.08590]], [ -0.06140, [ 3, -0.16667, 0.09332], [ 3, 0.16667, -0.09332]], [ -0.24702, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PointYouLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def PointYouRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.02015, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.01402, [ 3, -0.16667, 0.00614], [ 3, 0.16667, -0.00614]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27156, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.26849, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.26542, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.49391, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.54453, [ 3, -0.16667, 0.03298], [ 3, 0.16667, -0.03298]], [ -0.69179, [ 3, -0.16667, 0.05420], [ 3, 0.16667, -0.05420]], [ -0.86974, [ 3, -0.16667, 0.04679], [ 3, 0.16667, -0.04679]], [ -0.97251, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -0.97558, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ -0.98018, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.92803, [ 3, -0.16667, -0.02557], [ 3, 0.16667, 0.02557]], [ -0.82678, [ 3, -0.16667, -0.05113], [ 3, 0.16667, 0.05113]], [ -0.62123, [ 3, -0.16667, -0.05318], [ 3, 0.16667, 0.05318]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29781, [ 3, -0.16667, -0.00230], [ 3, 0.16667, 0.00230]], [ -1.29167, [ 3, -0.16667, -0.00179], [ 3, 0.16667, 0.00179]], [ -1.28707, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -1.28553, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28553, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28553, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28247, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28553, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.29167, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20100, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.14577, [ 3, -0.16667, 0.05522], [ 3, 0.16667, -0.05522]], [ -0.17177, [ 3, -0.16667, 0.05983], [ 3, 0.16667, -0.05983]], [ -0.23159, [ 3, -0.16667, 0.01636], [ 3, 0.16667, -0.01636]], [ -0.26994, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.25920, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.45402, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.31289, [ 3, -0.16667, -0.08590], [ 3, 0.16667, 0.08590]], [ 0.06140, [ 3, -0.16667, -0.09332], [ 3, 0.16667, 0.09332]], [ 0.24702, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.94192, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.85908, [ 3, -0.16667, 0.02199], [ 3, 0.16667, -0.02199]], [ 0.80999, [ 3, -0.16667, 0.01994], [ 3, 0.16667, -0.01994]], [ 0.73943, [ 3, -0.16667, 0.05216], [ 3, 0.16667, -0.05216]], [ 0.49706, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.48785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.48785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.61518, [ 3, -0.16667, -0.03809], [ 3, 0.16667, 0.03809]], [ 0.71642, [ 3, -0.16667, -0.02557], [ 3, 0.16667, 0.02557]], [ 0.76858, [ 3, -0.16667, -0.03912], [ 3, 0.16667, 0.03912]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23321, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23321, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.17492, [ 3, -0.16667, -0.03017], [ 3, 0.16667, 0.03017]], [ -0.05220, [ 3, -0.16667, -0.04244], [ 3, 0.16667, 0.04244]], [ 0.07973, [ 3, -0.16667, -0.03579], [ 3, 0.16667, 0.03579]], [ 0.16256, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.16103, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.12421, [ 3, -0.16667, 0.01969], [ 3, 0.16667, -0.01969]], [ 0.04291, [ 3, -0.16667, 0.03886], [ 3, 0.16667, -0.03886]], [ -0.10896, [ 3, -0.16667, 0.05292], [ 3, 0.16667, -0.05292]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.64270, [ 3, -0.16667, -0.06162], [ 3, 0.16667, 0.06162]], [ 0.87741, [ 3, -0.16667, -0.07849], [ 3, 0.16667, 0.07849]], [ 1.11364, [ 3, -0.16667, -0.06034], [ 3, 0.16667, 0.06034]], [ 1.23943, [ 3, -0.16667, -0.02531], [ 3, 0.16667, 0.02531]], [ 1.26551, [ 3, -0.16667, -0.00767], [ 3, 0.16667, 0.00767]], [ 1.28545, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 1.29772, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.26858, [ 3, -0.16667, 0.02915], [ 3, 0.16667, -0.02915]], [ 0.68872, [ 3, -0.16667, 0.12707], [ 3, 0.16667, -0.12707]], [ 0.50618, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.26252, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.26099, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.23645, [ 3, -0.16667, 0.02454], [ 3, 0.16667, -0.02454]], [ 1.04930, [ 3, -0.16667, 0.10124], [ 3, 0.16667, -0.10124]], [ 0.62898, [ 3, -0.16667, 0.02915], [ 3, 0.16667, -0.02915]], [ 0.59984, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.59984, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.62131, [ 3, -0.16667, -0.02147], [ 3, 0.16667, 0.02147]], [ 0.74710, [ 3, -0.16667, -0.05522], [ 3, 0.16667, 0.05522]], [ 0.95266, [ 3, -0.16667, -0.09306], [ 3, 0.16667, 0.09306]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.02143, [ 3, -0.16667, -0.15314], [ 3, 0.16667, 0.15314]], [ 0.71940, [ 3, -0.16667, -0.15749], [ 3, 0.16667, 0.15749]], [ 0.96638, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.96945, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.07069, [ 3, -0.16667, -0.05062], [ 3, 0.16667, 0.05062]], [ 1.27318, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.27625, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36505, [ 3, -0.16667, 0.08284], [ 3, 0.16667, -0.08284]], [ 0.28221, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.27915, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("PointYouRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def ChinHoldLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04615, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97712, [ 3, -0.16667, 0.02659], [ 3, 0.16667, -0.02659]], [ 0.88661, [ 3, -0.16667, 0.01866], [ 3, 0.16667, -0.01866]], [ 0.86513, [ 3, -0.16667, 0.01406], [ 3, 0.16667, -0.01406]], [ 0.80224, [ 3, -0.16667, 0.01381], [ 3, 0.16667, -0.01381]], [ 0.78230, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84519, [ 3, -0.16667, -0.04321], [ 3, 0.16667, 0.04321]], [ 1.04154, [ 3, -0.16667, -0.02148], [ 3, 0.16667, 0.02148]], [ 1.06302, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.05688, [ 3, -0.16667, 0.00614], [ 3, 0.16667, -0.00614]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.37425, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20705, [ 3, -0.16667, 0.05548], [ 3, 0.16667, -0.05548]], [ 0.04138, [ 3, -0.16667, 0.04295], [ 3, 0.16667, -0.04295]], [ -0.05066, [ 3, -0.16667, 0.04628], [ 3, 0.16667, -0.04628]], [ -0.23628, [ 3, -0.16667, 0.03784], [ 3, 0.16667, -0.03784]], [ -0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.00618, [ 3, -0.16667, -0.09971], [ 3, 0.16667, 0.09971]], [ 0.32056, [ 3, -0.16667, -0.03682], [ 3, 0.16667, 0.03682]], [ 0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.33437, [ 3, -0.16667, 0.01866], [ 3, 0.16667, -0.01866]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55228, [ 3, -0.16667, 0.03452], [ 3, 0.16667, -0.03452]], [ -0.64739, [ 3, -0.16667, 0.02710], [ 3, 0.16667, -0.02710]], [ -0.71489, [ 3, -0.16667, 0.01943], [ 3, 0.16667, -0.01943]], [ -0.76397, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ -0.76858, [ 3, -0.16667, 0.00281], [ 3, 0.16667, -0.00281]], [ -0.78085, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.74096, [ 3, -0.16667, -0.02633], [ 3, 0.16667, 0.02633]], [ -0.62285, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.62438, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.63972, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.45726, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.47106, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.47865, [ 3, -0.16667, 0.18025], [ 3, 0.16667, -0.18025]], [ -0.79926, [ 3, -0.16667, 0.10610], [ 3, 0.16667, -0.10610]], [ -1.11526, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.11679, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.11526, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.49552, [ 3, -0.16667, -0.15340], [ 3, 0.16667, 0.15340]], [ -0.19486, [ 3, -0.16667, -0.08514], [ 3, 0.16667, 0.08514]], [ 0.01530, [ 3, -0.16667, -0.07951], [ 3, 0.16667, 0.07951]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LHand")
    times.append([ 0.50000, 1.00000, 2.50000, 3.00000, 3.50000, 4.00000, 5.50000, 6.00000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.50000, 0.00000]], [ 0.01745, [ 3, -0.50000, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.50000, 0.00000]], [ 0.97280, [ 3, -0.50000, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91891, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22554, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.22401, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22401, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23014, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ -0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46476, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46629, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.46629, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.44482, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.21497, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.23184, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.23491, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.23338, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.23338, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.23031, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.22417, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ 1.22264, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 1.21957, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.22111, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09353, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.09507, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09353, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09353, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09507, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09507, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09353, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09353, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.09507, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.06294, [ 3, -0.16667, 0.04909], [ 3, 0.16667, -0.04909]], [ -0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("ChinHoldLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def ChinHoldRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91737, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91891, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.95112, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22554, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.22401, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22401, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22554, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23014, [ 3, -0.16667, -0.00460], [ 3, 0.16667, 0.00460]], [ 0.27463, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46476, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46629, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46783, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.46629, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.44482, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.21497, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.23184, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.23491, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.23338, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.23338, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.23031, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.22417, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ -1.22264, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -1.21957, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.22111, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.30548, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09353, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.09507, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09353, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09353, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09507, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09507, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09353, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09353, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.09507, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.06294, [ 3, -0.16667, -0.04909], [ 3, 0.16667, 0.04909]], [ 0.19946, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04615, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97712, [ 3, -0.16667, 0.02659], [ 3, 0.16667, -0.02659]], [ 0.88661, [ 3, -0.16667, 0.01866], [ 3, 0.16667, -0.01866]], [ 0.86513, [ 3, -0.16667, 0.01406], [ 3, 0.16667, -0.01406]], [ 0.80224, [ 3, -0.16667, 0.01381], [ 3, 0.16667, -0.01381]], [ 0.78230, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.84519, [ 3, -0.16667, -0.04321], [ 3, 0.16667, 0.04321]], [ 1.04154, [ 3, -0.16667, -0.02148], [ 3, 0.16667, 0.02148]], [ 1.06302, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.05688, [ 3, -0.16667, 0.00614], [ 3, 0.16667, -0.00614]], [ 0.92343, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.37425, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20705, [ 3, -0.16667, -0.05548], [ 3, 0.16667, 0.05548]], [ -0.04138, [ 3, -0.16667, -0.04295], [ 3, 0.16667, 0.04295]], [ 0.05066, [ 3, -0.16667, -0.04628], [ 3, 0.16667, 0.04628]], [ 0.23628, [ 3, -0.16667, -0.03784], [ 3, 0.16667, 0.03784]], [ 0.27770, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.00618, [ 3, -0.16667, 0.09971], [ 3, 0.16667, -0.09971]], [ -0.32056, [ 3, -0.16667, 0.03682], [ 3, 0.16667, -0.03682]], [ -0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.33437, [ 3, -0.16667, -0.01866], [ 3, 0.16667, 0.01866]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.55228, [ 3, -0.16667, -0.03452], [ 3, 0.16667, 0.03452]], [ 0.64739, [ 3, -0.16667, -0.02710], [ 3, 0.16667, 0.02710]], [ 0.71489, [ 3, -0.16667, -0.01943], [ 3, 0.16667, 0.01943]], [ 0.76397, [ 3, -0.16667, -0.00460], [ 3, 0.16667, 0.00460]], [ 0.76858, [ 3, -0.16667, -0.00281], [ 3, 0.16667, 0.00281]], [ 0.78085, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.74096, [ 3, -0.16667, 0.02633], [ 3, 0.16667, -0.02633]], [ 0.62285, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.62438, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.63972, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.44030, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.45726, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.47106, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.28852, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000])
    keys.append([ [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.47865, [ 3, -0.16667, -0.18025], [ 3, 0.16667, 0.18025]], [ 0.79926, [ 3, -0.16667, -0.10610], [ 3, 0.16667, 0.10610]], [ 1.11526, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.11679, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.11526, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.49552, [ 3, -0.16667, 0.15340], [ 3, 0.16667, -0.15340]], [ 0.19486, [ 3, -0.16667, 0.08514], [ 3, 0.16667, -0.08514]], [ -0.01530, [ 3, -0.16667, 0.07951], [ 3, 0.16667, -0.07951]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28221, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RHand")
    times.append([ 0.50000, 1.00000, 2.50000, 3.00000, 3.50000, 4.00000, 5.50000, 6.00000])
    keys.append([ [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.50000, 0.00000]], [ 0.01745, [ 3, -0.50000, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.01745, [ 3, -0.16667, 0.00000], [ 3, 0.50000, 0.00000]], [ 0.97280, [ 3, -0.50000, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("ChinHoldRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Whisper():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.89436, [ 3, -0.16667, 0.03119], [ 3, 0.16667, -0.03119]], [ 0.77471, [ 3, -0.16667, 0.03221], [ 3, 0.16667, -0.03221]], [ 0.70108, [ 3, -0.16667, 0.05931], [ 3, 0.16667, -0.05931]], [ 0.41882, [ 3, -0.16667, 0.05957], [ 3, 0.16667, -0.05957]], [ 0.34366, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35900, [ 3, -0.16667, -0.00818], [ 3, 0.16667, 0.00818]], [ 0.39275, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.48325, [ 3, -0.16667, -0.05804], [ 3, 0.16667, 0.05804]], [ 0.72869, [ 3, -0.16667, -0.06315], [ 3, 0.16667, 0.06315]], [ 0.86215, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.86522, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.88209, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88209, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88363, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23781, [ 3, -0.16667, 0.00716], [ 3, 0.16667, -0.00716]], [ 0.22401, [ 3, -0.16667, 0.01381], [ 3, 0.16667, -0.01381]], [ 0.08441, [ 3, -0.16667, 0.02608], [ 3, 0.16667, -0.02608]], [ 0.05833, [ 3, -0.16667, 0.02531], [ 3, 0.16667, -0.02531]], [ -0.06745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.06745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.06439, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.06132, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.05825, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.05672, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -0.05518, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.05211, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.00149, [ 3, -0.16667, -0.04321], [ 3, 0.16667, 0.04321]], [ 0.20713, [ 3, -0.16667, -0.04704], [ 3, 0.16667, 0.04704]], [ 0.28076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27616, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ 0.27309, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.27003, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50618, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -0.50464, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.51385, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ -0.58901, [ 3, -0.16667, 0.02327], [ 3, 0.16667, -0.02327]], [ -0.65344, [ 3, -0.16667, 0.02224], [ 3, 0.16667, -0.02224]], [ -0.72247, [ 3, -0.16667, 0.02557], [ 3, 0.16667, -0.02557]], [ -0.80684, [ 3, -0.16667, 0.02020], [ 3, 0.16667, -0.02020]], [ -0.84366, [ 3, -0.16667, 0.01585], [ 3, 0.16667, -0.01585]], [ -0.90195, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.87741, [ 3, -0.16667, -0.00895], [ 3, 0.16667, 0.00895]], [ -0.84826, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.85440, [ 3, -0.16667, 0.00384], [ 3, 0.16667, -0.00384]], [ -0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.86820, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.76236, [ 3, -0.16667, -0.05011], [ 3, 0.16667, 0.05011]], [ -0.56754, [ 3, -0.16667, -0.06110], [ 3, 0.16667, 0.06110]], [ -0.39573, [ 3, -0.16667, -0.03068], [ 3, 0.16667, 0.03068]], [ -0.36505, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.36198, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -1.32082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32235, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32235, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.35456, [ 3, -0.16667, 0.00895], [ 3, 0.16667, -0.00895]], [ -1.37451, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.37757, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54171, [ 3, -0.16667, -0.00100], [ 3, 0.16667, 0.00100]], [ -1.53864, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -1.46194, [ 3, -0.16667, -0.03503], [ 3, 0.16667, 0.03503]], [ -1.32849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33309, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.34979, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.32985, [ 3, -0.16667, 0.01048], [ 3, 0.16667, -0.01048]], [ 0.28690, [ 3, -0.16667, 0.01918], [ 3, 0.16667, -0.01918]], [ 0.21480, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21480, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.18872, [ 3, -0.16667, 0.01917], [ 3, 0.16667, -0.01917]], [ 0.09975, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.18566, [ 3, -0.16667, -0.01739], [ 3, 0.16667, 0.01739]], [ 0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22861, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LHand")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.89436, [ 3, -0.16667, 0.03119], [ 3, 0.16667, -0.03119]], [ 0.77471, [ 3, -0.16667, 0.03221], [ 3, 0.16667, -0.03221]], [ 0.70108, [ 3, -0.16667, 0.05931], [ 3, 0.16667, -0.05931]], [ 0.41882, [ 3, -0.16667, 0.05957], [ 3, 0.16667, -0.05957]], [ 0.34366, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35900, [ 3, -0.16667, -0.00818], [ 3, 0.16667, 0.00818]], [ 0.39275, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.48325, [ 3, -0.16667, -0.05804], [ 3, 0.16667, 0.05804]], [ 0.72869, [ 3, -0.16667, -0.06315], [ 3, 0.16667, 0.06315]], [ 0.86215, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.86522, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.88209, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88209, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88363, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23781, [ 3, -0.16667, -0.00716], [ 3, 0.16667, 0.00716]], [ -0.22401, [ 3, -0.16667, -0.01381], [ 3, 0.16667, 0.01381]], [ -0.08441, [ 3, -0.16667, -0.02608], [ 3, 0.16667, 0.02608]], [ -0.05833, [ 3, -0.16667, -0.02531], [ 3, 0.16667, 0.02531]], [ 0.06745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.06745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.06439, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.06132, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.05825, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.05672, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 0.05518, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.05211, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.00149, [ 3, -0.16667, 0.04321], [ 3, 0.16667, -0.04321]], [ -0.20713, [ 3, -0.16667, 0.04704], [ 3, 0.16667, -0.04704]], [ -0.28076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27616, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ -0.27309, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.27003, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50618, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 0.50464, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.51385, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ 0.58901, [ 3, -0.16667, -0.02327], [ 3, 0.16667, 0.02327]], [ 0.65344, [ 3, -0.16667, -0.02224], [ 3, 0.16667, 0.02224]], [ 0.72247, [ 3, -0.16667, -0.02557], [ 3, 0.16667, 0.02557]], [ 0.80684, [ 3, -0.16667, -0.02020], [ 3, 0.16667, 0.02020]], [ 0.84366, [ 3, -0.16667, -0.01585], [ 3, 0.16667, 0.01585]], [ 0.90195, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87741, [ 3, -0.16667, 0.00895], [ 3, 0.16667, -0.00895]], [ 0.84826, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85440, [ 3, -0.16667, -0.00383], [ 3, 0.16667, 0.00383]], [ 0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86820, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.76236, [ 3, -0.16667, 0.05011], [ 3, 0.16667, -0.05011]], [ 0.56754, [ 3, -0.16667, 0.06110], [ 3, 0.16667, -0.06110]], [ 0.39573, [ 3, -0.16667, 0.03068], [ 3, 0.16667, -0.03068]], [ 0.36505, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.36198, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 1.32082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32235, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32235, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.35456, [ 3, -0.16667, -0.00895], [ 3, 0.16667, 0.00895]], [ 1.37451, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.37757, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54171, [ 3, -0.16667, 0.00100], [ 3, 0.16667, -0.00100]], [ 1.53864, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 1.46194, [ 3, -0.16667, 0.03503], [ 3, 0.16667, -0.03503]], [ 1.32849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33309, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.34979, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.32985, [ 3, -0.16667, -0.01048], [ 3, 0.16667, 0.01048]], [ -0.28690, [ 3, -0.16667, -0.01917], [ 3, 0.16667, 0.01917]], [ -0.21480, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21480, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.18872, [ 3, -0.16667, -0.01918], [ 3, 0.16667, 0.01918]], [ -0.09975, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.18566, [ 3, -0.16667, 0.01739], [ 3, 0.16667, -0.01739]], [ -0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22861, [ 3, -0.16667, 0.00537], [ 3, 0.16667, -0.00537]], [ -0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RHand")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("Whisper")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def WhisperLeft():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.89436, [ 3, -0.16667, 0.03119], [ 3, 0.16667, -0.03119]], [ 0.77471, [ 3, -0.16667, 0.03221], [ 3, 0.16667, -0.03221]], [ 0.70108, [ 3, -0.16667, 0.05931], [ 3, 0.16667, -0.05931]], [ 0.41882, [ 3, -0.16667, 0.05957], [ 3, 0.16667, -0.05957]], [ 0.34366, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35900, [ 3, -0.16667, -0.00818], [ 3, 0.16667, 0.00818]], [ 0.39275, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.48325, [ 3, -0.16667, -0.05804], [ 3, 0.16667, 0.05804]], [ 0.72869, [ 3, -0.16667, -0.06315], [ 3, 0.16667, 0.06315]], [ 0.86215, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.86522, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.88209, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88209, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88363, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23781, [ 3, -0.16667, 0.00716], [ 3, 0.16667, -0.00716]], [ 0.22401, [ 3, -0.16667, 0.01381], [ 3, 0.16667, -0.01381]], [ 0.08441, [ 3, -0.16667, 0.02608], [ 3, 0.16667, -0.02608]], [ 0.05833, [ 3, -0.16667, 0.02531], [ 3, 0.16667, -0.02531]], [ -0.06745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.06745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.06439, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.06132, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.05825, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.05672, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -0.05518, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.05211, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.00149, [ 3, -0.16667, -0.04321], [ 3, 0.16667, 0.04321]], [ 0.20713, [ 3, -0.16667, -0.04704], [ 3, 0.16667, 0.04704]], [ 0.28076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.28076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27616, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ 0.27309, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.27003, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.50618, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ -0.50464, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.51385, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ -0.58901, [ 3, -0.16667, 0.02327], [ 3, 0.16667, -0.02327]], [ -0.65344, [ 3, -0.16667, 0.02224], [ 3, 0.16667, -0.02224]], [ -0.72247, [ 3, -0.16667, 0.02557], [ 3, 0.16667, -0.02557]], [ -0.80684, [ 3, -0.16667, 0.02020], [ 3, 0.16667, -0.02020]], [ -0.84366, [ 3, -0.16667, 0.01585], [ 3, 0.16667, -0.01585]], [ -0.90195, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.87741, [ 3, -0.16667, -0.00895], [ 3, 0.16667, 0.00895]], [ -0.84826, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.85440, [ 3, -0.16667, 0.00384], [ 3, 0.16667, -0.00384]], [ -0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.86820, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.76236, [ 3, -0.16667, -0.05011], [ 3, 0.16667, 0.05011]], [ -0.56754, [ 3, -0.16667, -0.06110], [ 3, 0.16667, 0.06110]], [ -0.39573, [ 3, -0.16667, -0.03068], [ 3, 0.16667, 0.03068]], [ -0.36505, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.36198, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -1.32082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32235, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32235, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.35456, [ 3, -0.16667, 0.00895], [ 3, 0.16667, -0.00895]], [ -1.37451, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.37757, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.54171, [ 3, -0.16667, -0.00100], [ 3, 0.16667, 0.00100]], [ -1.53864, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -1.46194, [ 3, -0.16667, -0.03503], [ 3, 0.16667, 0.03503]], [ -1.32849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.32849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33309, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.34979, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.32985, [ 3, -0.16667, 0.01048], [ 3, 0.16667, -0.01048]], [ 0.28690, [ 3, -0.16667, 0.01918], [ 3, 0.16667, -0.01918]], [ 0.21480, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21480, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.18872, [ 3, -0.16667, 0.01917], [ 3, 0.16667, -0.01917]], [ 0.09975, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.18566, [ 3, -0.16667, -0.01739], [ 3, 0.16667, 0.01739]], [ 0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.22861, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LHand")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 1.04768, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04768, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04768, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04615, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.03848, [ 3, -0.16667, 0.00639], [ 3, 0.16667, -0.00639]], [ 1.00780, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.00933, [ 3, -0.16667, -0.00741], [ 3, 0.16667, 0.00741]], [ 1.03234, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.36198, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36198, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36198, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.36045, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.32056, [ 3, -0.16667, -0.01866], [ 3, 0.16667, 0.01866]], [ -0.24847, [ 3, -0.16667, -0.01508], [ 3, 0.16667, 0.01508]], [ -0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24386, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24386, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.23159, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24386, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ -0.28682, [ 3, -0.16667, 0.01841], [ 3, 0.16667, -0.01841]], [ -0.35431, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ -0.35585, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ -0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.56609, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.56609, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.56609, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.56609, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.63205, [ 3, -0.16667, -0.03145], [ 3, 0.16667, 0.03145]], [ 0.75477, [ 3, -0.16667, -0.02148], [ 3, 0.16667, 0.02148]], [ 0.77625, [ 3, -0.16667, -0.00435], [ 3, 0.16667, 0.00435]], [ 0.78085, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ 0.78392, [ 3, -0.16667, -0.00256], [ 3, 0.16667, 0.00256]], [ 0.79619, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.79312, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.75937, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.89283, [ 3, -0.16667, -0.04551], [ 3, 0.16667, 0.04551]], [ 1.03242, [ 3, -0.16667, -0.03170], [ 3, 0.16667, 0.03170]], [ 1.08305, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.08305, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99254, [ 3, -0.16667, 0.04807], [ 3, 0.16667, -0.04807]], [ 0.79465, [ 3, -0.16667, 0.05037], [ 3, 0.16667, -0.05037]], [ 0.69034, [ 3, -0.16667, 0.03988], [ 3, 0.16667, -0.03988]], [ 0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.55382, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.47567, [ 3, -0.16667, -0.00460], [ 3, 0.16667, 0.00460]], [ 1.49561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.49561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.49101, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.48334, [ 3, -0.16667, 0.00358], [ 3, 0.16667, -0.00358]], [ 1.46953, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.47567, [ 3, -0.16667, -0.00384], [ 3, 0.16667, 0.00384]], [ 1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.49101, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.47720, [ 3, -0.16667, 0.00384], [ 3, 0.16667, -0.00384]], [ 1.46953, [ 3, -0.16667, 0.00179], [ 3, 0.16667, -0.00179]], [ 1.46646, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ 1.46186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.46186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.34357, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.34511, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.34357, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.34357, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.33437, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ -0.26534, [ 3, -0.16667, -0.01636], [ 3, 0.16667, 0.01636]], [ -0.23619, [ 3, -0.16667, -0.01457], [ 3, 0.16667, 0.01457]], [ -0.17790, [ 3, -0.16667, -0.01202], [ 3, 0.16667, 0.01202]], [ -0.16410, [ 3, -0.16667, -0.00358], [ 3, 0.16667, 0.00358]], [ -0.15643, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21012, [ 3, -0.16667, 0.03451], [ 3, 0.16667, -0.03451]], [ -0.36352, [ 3, -0.16667, 0.04576], [ 3, 0.16667, -0.04576]], [ -0.48470, [ 3, -0.16667, 0.04449], [ 3, 0.16667, -0.04449]], [ -0.63043, [ 3, -0.16667, 0.03119], [ 3, 0.16667, -0.03119]], [ -0.67185, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.67185, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.54146, [ 3, -0.16667, -0.02838], [ 3, 0.16667, 0.02838]], [ -0.50158, [ 3, -0.16667, -0.01866], [ 3, 0.16667, 0.01866]], [ -0.42948, [ 3, -0.16667, -0.01560], [ 3, 0.16667, 0.01560]], [ -0.40800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.40954, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27915, [ 3, -0.16667, -0.02684], [ 3, 0.16667, 0.02684]], [ -0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RHand")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("WhisperLeft")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def WhisperRight():
    names = list()
    times = list()
    keys = list()

    names.append("LShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 1.04768, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04768, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04768, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04615, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 1.03848, [ 3, -0.16667, 0.00639], [ 3, 0.16667, -0.00639]], [ 1.00780, [ 3, -0.16667, 0.00767], [ 3, 0.16667, -0.00767]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.99246, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.98785, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.00933, [ 3, -0.16667, -0.00741], [ 3, 0.16667, 0.00741]], [ 1.03234, [ 3, -0.16667, -0.00537], [ 3, 0.16667, 0.00537]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.04154, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.36198, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36198, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36198, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36045, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.32056, [ 3, -0.16667, 0.01866], [ 3, 0.16667, -0.01866]], [ 0.24847, [ 3, -0.16667, 0.01508], [ 3, 0.16667, -0.01508]], [ 0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.23006, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24386, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24540, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24386, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.23159, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24386, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ 0.28682, [ 3, -0.16667, -0.01841], [ 3, 0.16667, 0.01841]], [ 0.35431, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 0.35585, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ 0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35738, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.56609, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.56609, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.56609, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.56609, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.63205, [ 3, -0.16667, 0.03145], [ 3, 0.16667, -0.03145]], [ -0.75477, [ 3, -0.16667, 0.02148], [ 3, 0.16667, -0.02148]], [ -0.77625, [ 3, -0.16667, 0.00435], [ 3, 0.16667, -0.00435]], [ -0.78085, [ 3, -0.16667, 0.00128], [ 3, 0.16667, -0.00128]], [ -0.78392, [ 3, -0.16667, 0.00256], [ 3, 0.16667, -0.00256]], [ -0.79619, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.79312, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ -0.75937, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.89283, [ 3, -0.16667, 0.04551], [ 3, 0.16667, -0.04551]], [ -1.03242, [ 3, -0.16667, 0.03170], [ 3, 0.16667, -0.03170]], [ -1.08305, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.08305, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.99254, [ 3, -0.16667, -0.04807], [ 3, 0.16667, 0.04807]], [ -0.79465, [ 3, -0.16667, -0.05037], [ 3, 0.16667, 0.05037]], [ -0.69034, [ 3, -0.16667, -0.03988], [ 3, 0.16667, 0.03988]], [ -0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55382, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.55535, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.47567, [ 3, -0.16667, 0.00460], [ 3, 0.16667, -0.00460]], [ -1.49561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.49561, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.49101, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -1.48334, [ 3, -0.16667, -0.00358], [ 3, 0.16667, 0.00358]], [ -1.46953, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.47567, [ 3, -0.16667, 0.00384], [ 3, 0.16667, -0.00384]], [ -1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.49101, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.49254, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.47720, [ 3, -0.16667, -0.00384], [ 3, 0.16667, 0.00384]], [ -1.46953, [ 3, -0.16667, -0.00179], [ 3, 0.16667, 0.00179]], [ -1.46646, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ -1.46186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.46186, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -1.46800, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.34357, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.34511, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.34357, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.34357, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.33437, [ 3, -0.16667, 0.00920], [ 3, 0.16667, -0.00920]], [ 0.26534, [ 3, -0.16667, 0.01636], [ 3, 0.16667, -0.01636]], [ 0.23619, [ 3, -0.16667, 0.01457], [ 3, 0.16667, -0.01457]], [ 0.17790, [ 3, -0.16667, 0.01202], [ 3, 0.16667, -0.01202]], [ 0.16410, [ 3, -0.16667, 0.00358], [ 3, 0.16667, -0.00358]], [ 0.15643, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.21012, [ 3, -0.16667, -0.03451], [ 3, 0.16667, 0.03451]], [ 0.36352, [ 3, -0.16667, -0.04576], [ 3, 0.16667, 0.04576]], [ 0.48470, [ 3, -0.16667, -0.04449], [ 3, 0.16667, 0.04449]], [ 0.63043, [ 3, -0.16667, -0.03119], [ 3, 0.16667, 0.03119]], [ 0.67185, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.67185, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.54146, [ 3, -0.16667, 0.02838], [ 3, 0.16667, -0.02838]], [ 0.50158, [ 3, -0.16667, 0.01866], [ 3, 0.16667, -0.01866]], [ 0.42948, [ 3, -0.16667, 0.01560], [ 3, 0.16667, -0.01560]], [ 0.40800, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.40954, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.27915, [ 3, -0.16667, 0.02684], [ 3, 0.16667, -0.02684]], [ 0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.24847, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("LHand")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.97240, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96339, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.96186, [ 3, -0.16667, 0.00153], [ 3, 0.16667, -0.00153]], [ 0.89436, [ 3, -0.16667, 0.03119], [ 3, 0.16667, -0.03119]], [ 0.77471, [ 3, -0.16667, 0.03221], [ 3, 0.16667, -0.03221]], [ 0.70108, [ 3, -0.16667, 0.05931], [ 3, 0.16667, -0.05931]], [ 0.41882, [ 3, -0.16667, 0.05957], [ 3, 0.16667, -0.05957]], [ 0.34366, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.35900, [ 3, -0.16667, -0.00818], [ 3, 0.16667, 0.00818]], [ 0.39275, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.38047, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.48325, [ 3, -0.16667, -0.05804], [ 3, 0.16667, 0.05804]], [ 0.72869, [ 3, -0.16667, -0.06315], [ 3, 0.16667, 0.06315]], [ 0.86215, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.86522, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 0.88209, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88209, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88363, [ 3, -0.16667, -0.00051], [ 3, 0.16667, 0.00051]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.88516, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RShoulderRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26389, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26696, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23781, [ 3, -0.16667, -0.00716], [ 3, 0.16667, 0.00716]], [ -0.22401, [ 3, -0.16667, -0.01381], [ 3, 0.16667, 0.01381]], [ -0.08441, [ 3, -0.16667, -0.02608], [ 3, 0.16667, 0.02608]], [ -0.05833, [ 3, -0.16667, -0.02531], [ 3, 0.16667, 0.02531]], [ 0.06745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.06745, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.06439, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.06132, [ 3, -0.16667, 0.00102], [ 3, 0.16667, -0.00102]], [ 0.05825, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.05672, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 0.05518, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.05211, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.00149, [ 3, -0.16667, 0.04321], [ 3, 0.16667, -0.04321]], [ -0.20713, [ 3, -0.16667, 0.04704], [ 3, 0.16667, -0.04704]], [ -0.28076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.28076, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27616, [ 3, -0.16667, -0.00128], [ 3, 0.16667, 0.00128]], [ -0.27309, [ 3, -0.16667, -0.00102], [ 3, 0.16667, 0.00102]], [ -0.27003, [ 3, -0.16667, -0.00077], [ 3, 0.16667, 0.00077]], [ -0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.26849, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.50771, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.50618, [ 3, -0.16667, 0.00051], [ 3, 0.16667, -0.00051]], [ 0.50464, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.51385, [ 3, -0.16667, -0.00920], [ 3, 0.16667, 0.00920]], [ 0.58901, [ 3, -0.16667, -0.02327], [ 3, 0.16667, 0.02327]], [ 0.65344, [ 3, -0.16667, -0.02224], [ 3, 0.16667, 0.02224]], [ 0.72247, [ 3, -0.16667, -0.02557], [ 3, 0.16667, 0.02557]], [ 0.80684, [ 3, -0.16667, -0.02020], [ 3, 0.16667, 0.02020]], [ 0.84366, [ 3, -0.16667, -0.01585], [ 3, 0.16667, 0.01585]], [ 0.90195, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87741, [ 3, -0.16667, 0.00895], [ 3, 0.16667, -0.00895]], [ 0.84826, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.85440, [ 3, -0.16667, -0.00384], [ 3, 0.16667, 0.00384]], [ 0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.87127, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.86820, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.76236, [ 3, -0.16667, 0.05011], [ 3, 0.16667, -0.05011]], [ 0.56754, [ 3, -0.16667, 0.06110], [ 3, 0.16667, -0.06110]], [ 0.39573, [ 3, -0.16667, 0.03068], [ 3, 0.16667, -0.03068]], [ 0.36505, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 0.36198, [ 3, -0.16667, 0.00077], [ 3, 0.16667, -0.00077]], [ 0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.36045, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RElbowRoll")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 1.32082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32235, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32235, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32082, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.35456, [ 3, -0.16667, -0.00895], [ 3, 0.16667, 0.00895]], [ 1.37451, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.37757, [ 3, -0.16667, -0.00307], [ 3, 0.16667, 0.00307]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54462, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.54171, [ 3, -0.16667, 0.00100], [ 3, 0.16667, -0.00100]], [ 1.53864, [ 3, -0.16667, 0.00307], [ 3, 0.16667, -0.00307]], [ 1.46194, [ 3, -0.16667, 0.03503], [ 3, 0.16667, -0.03503]], [ 1.32849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.32849, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33309, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ 1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 1.33769, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RWristYaw")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ -0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35286, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.35133, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.34979, [ 3, -0.16667, -0.00153], [ 3, 0.16667, 0.00153]], [ -0.32985, [ 3, -0.16667, -0.01048], [ 3, 0.16667, 0.01048]], [ -0.28690, [ 3, -0.16667, -0.01918], [ 3, 0.16667, 0.01918]], [ -0.21480, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.21480, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.18872, [ 3, -0.16667, -0.01917], [ 3, 0.16667, 0.01917]], [ -0.09975, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.18566, [ 3, -0.16667, 0.01739], [ 3, 0.16667, -0.01739]], [ -0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.20406, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.22861, [ 3, -0.16667, 0.00537], [ 3, 0.16667, -0.00537]], [ -0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.23628, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ -0.27003, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    names.append("RHand")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000, 4.50000, 5.00000, 5.50000, 6.00000, 6.50000, 7.00000, 7.50000, 8.00000, 8.50000, 9.00000, 9.50000, 10.00000, 10.50000, 11.00000, 11.50000, 12.00000, 12.50000])
    keys.append([ [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.16667, 0.00000]], [ 0.91280, [ 3, -0.16667, 0.00000], [ 3, 0.00000, 0.00000]]])

    motion = NaoMotion("WhisperRight")
    motion.init(names, times, keys, NaoMotion.METHOD_BEZIER)
    return motion
#END motion

def Nod1():
    names = list()
    times = list()
    keys = list()

    names.append("HeadPitch")
    times.append([ 0.50000, 1.00000, 1.50000, 2.00000, 2.50000, 3.00000, 3.50000, 4.00000])
    keys.append([ -0.01692, -0.01692, 0.02450, 0.16870, 0.22546, 0.15949, -0.01692, -0.01692])

    motion = NaoMotion("Nod1")
    motion.init(names, times, keys, NaoMotion.METHOD_SIMPLIFIED)
    return motion
#END motion
