from PyQt4 import QtCore
from PyQt4 import QtNetwork
import struct

class NaoTextToSpeech(QtCore.QObject):
    _HEADER = b'COMMAND|'

    def __init__(self):
        super(NaoTextToSpeech, self).__init__()
        self.post = self;
        self._socket = None
    #END __init__()

    def __del__(self):
        self.disconnectFromHost()
    #END __del__()

    def __str__(self):
        return "NaoTextToSpeech"
    #END __str__()

    def connectToHost(self, address, port = 9555):
        self._socket = QtNetwork.QTcpSocket(self)
        self._socket.readyRead.connect(self.on__socket_readyRead)
        self._socket.connectToHost(address, port)
        if not self._socket.waitForConnected(5000):
            self._socket.disconnectFromHost()
            self._socket = None
        #END if
    #END connectToHost()

    def disconnectFromHost(self):
        if self._socket is not None:
            self._socket.disconnectFromHost()
            self._socket = None
        #END if
    #END disconnectFromHost()

    def say(self, text):
        if self._socket is not None and text != "":
            text = "SAY|" + text
            packet = QtCore.QByteArray()
            packet.append(NaoTextToSpeech._HEADER)
            packet.append(struct.pack("I", len(NaoTextToSpeech._HEADER) + 4 + len(text)))
            packet.append(text.encode('ascii'))
            self._socket.write(packet)
        #END if
        return 0 # say id
    #END say()

    def setVolume(self, value):
        pass
    #END setVolume()

    def stop(self, speechId):
        pass
    #END stop()

    def wait(self, speechId, waitTime):
        pass
    #END wait()

    def on__socket_readyRead(self):
        packet = self._socket.readAll()
    #END on__socket_readyRead()
#END class
