from PyQt4 import QtCore
from Action import BaseAction
from Action import Motion
from Action import Stiffness
from Nao import NaoMotion
from MotionList import MotionList
import random


class ActionCollection(QtCore.QObject):
    INDEX_ACTIONS = 0
    INDEX_MOTION = 1

    def __init__(self, name = ""):
        super(ActionCollection, self).__init__()
        self._name = name
        self._list = dict() # list of actions and motions
        self._maxLevel = 0 # max level in the list
    #END __init__()

    def add(self, level, actions = None, motions = None, insert_sequence = False):
        if not level in self._list:
            self._maxLevel = max(self._maxLevel, level)
            self._list[level] = [[], []]
        #END if

        if actions is not None:
            if isinstance(actions, BaseAction):
                actions = [actions]
            #END if
            if len(actions) > 0:
                if insert_sequence:
                    if len(self._list[level][ActionCollection.INDEX_ACTIONS]) <= 0:
                        self._list[level][ActionCollection.INDEX_ACTIONS].append([])
                    #END if
                    self._list[level][ActionCollection.INDEX_ACTIONS][-1] += actions
                else:
                    self._list[level][ActionCollection.INDEX_ACTIONS].append(actions)
                #END if
            #END if
        #END if

        if motions is not None:
            if isinstance(motions, str):
                tmp = []
                motion = MotionList.getByName(str(level) + "_" + motions)
                if motion is not None:
                    tmp.append(Motion(motion = motion, blocking = False))
                #END if
                motions = tmp
            elif isinstance(motions, NaoMotion):
                motions = [Motion(motion = motions, blocking = False)]
            else:
                tmp = []
                for item in motions:
                    if isinstance(motions, str):
                        motion = MotionList.getByName(str(level) + "_" + item)
                        if motion is not None:
                            tmp.append(Motion(motion = motion, blocking = False))
                        #END if
                    elif isinstance(motions, NaoMotion):
                        tmp.append(Motion(motion = item, blocking = False))
                    #END if
                #END for
                motions = tmp
            #END if
            if len(motions) > 0:
                if insert_sequence:
                    if len(self._list[level][ActionCollection.INDEX_MOTION]) <= 0:
                        self._list[level][ActionCollection.INDEX_MOTION].append([])
                    #END if
                    self._list[level][ActionCollection.INDEX_MOTION][-1] += motions
                else:
                    self._list[level][ActionCollection.INDEX_MOTION].append(motions)
                #END if
            #END if
        #END if
    #END add()

    def get(self, level):
        motions = []
        curr = level
        while len(motions) <= 0 and curr >= 0:
            if curr in self._list and len(self._list[curr][ActionCollection.INDEX_MOTION]) > 0:
                val = random.randint(0, len(self._list[curr][ActionCollection.INDEX_MOTION]) - 1)
                motions.append(Stiffness(1.0))
                motions += self._list[curr][ActionCollection.INDEX_MOTION][val]
            #END if
            curr -= 1
        #END while
        actions = []
        curr = level
        while len(actions) <= 0 and curr >= 0:
            if curr in self._list and len(self._list[curr][ActionCollection.INDEX_ACTIONS]) > 0:
                val = random.randint(0, len(self._list[curr][ActionCollection.INDEX_ACTIONS]) - 1)
                actions += self._list[curr][ActionCollection.INDEX_ACTIONS][val]
            #END if
            curr -= 1
        #END while
        return motions + actions
    #END get()

    def getMaxLevel(self):
        return self._maxLevel
    #END getMaxLevel()

    def getName(self):
        return self._name
    #END getName()
#END class
