from PyQt4 import QtCore
from PyQt4 import QtGui
from Action import Behavior
from Action import LED
from Action import Motion
from Action import Speech
from Action import Stiffness
from Action import Wait
from Nao.NaoMotionList import NaoMotionList
from UI.ActionPushButton import ActionPushButton
from ActionCollection import ActionCollection
from EmpathyButton import EmpathyButton
from EmpathySpeech import EmpathySpeech
from MotionList import MotionList
from Text import Text
import Constants

class EmpathyComponent(object):
    @staticmethod
    def setupWidget(wgt, children, onActionButtonClicked):
        widget = QtGui.QWidget()
        layout = QtGui.QVBoxLayout(widget)
        layout.setMargin(0)
        for child in children:
            if onActionButtonClicked is not None and isinstance(child, QtGui.QPushButton):
                child.clicked.connect(onActionButtonClicked)
            #END if
            layout.addWidget(child)
        #END for
        scroll = QtGui.QScrollArea()
        scroll.setAlignment(QtCore.Qt.AlignCenter)
        scroll.setWidget(widget)
        layoutScroll = QtGui.QHBoxLayout()
        layoutScroll.setMargin(0)
        layoutScroll.addWidget(scroll)
        widget = QtGui.QWidget(wgt)
        widget.setLayout(layoutScroll)
        return widget
    #END setupWidget()

    @staticmethod
    def factoryInteractions():
        components = list()
        specials = dict()
        texts = dict()

        bhv = ActionCollection("Conv. Movement")
        for i in range(10):
            bhv.add(i, None, "Idle0")
            bhv.add(i, None, "Idle1")
            bhv.add(i, None, "Idle2")
            bhv.add(i, None, "Idle3")
            bhv.add(i, None, "Idle4")
            bhv.add(i, None, "Idle5")
            bhv.add(i, None, "Idle6")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))
        specials[Constants.BHV_MOVEMENT] = bhv

        bhv = ActionCollection("Conv. Filler")
        bhv.add(0, [Speech("ummmh,", 50), Text("Umm")])
        bhv.add(0, [Speech("well,", 50), Text("Well")])
        bhv.add(0, [Speech("well,", 50), Text("Well")])
        bhv.add(0, [Speech("let me think", 80), Text("Let me think")])
        bhv.add(0, [Speech("let's see", 80), Text("Let's see")])
        bhv.add(2, [Speech("ummmh,", 50), Text("Umm")])
        bhv.add(2, [Speech("well,", 50), Text("Well")])
        bhv.add(2, [Speech("well,", 50), Text("Well")])
        bhv.add(2, [Speech("let me think", 80), Text("Let me think")])
        bhv.add(2, [Speech("let's see", 80), Text("Let's see")])
        bhv.add(2, [Speech("ummmh,", 60, 110), Text("Umm")])
        bhv.add(2, [Speech("well,", 60, 110), Text("Well")])
        bhv.add(2, [Speech("well,", 60, 110), Text("Well")])
        bhv.add(2, [Speech("let me think", 90, 110), Text("Let me think")])
        bhv.add(2, [Speech("let's see", 90, 110), Text("Let's see")])
        bhv.add(3, [Speech("ummmh,", 50), Text("Umm")])
        bhv.add(3, [Speech("well,", 50), Text("Well")])
        bhv.add(3, [Speech("well,", 50), Text("Well")])
        bhv.add(3, [Speech("let me think", 80), Text("Let me think")])
        bhv.add(3, [Speech("let's see", 80), Text("Let's see")])
        bhv.add(3, [Speech("ummmh,", 70, 130), Text("Umm")])
        bhv.add(3, [Speech("well,", 70, 130), Text("Well")])
        bhv.add(3, [Speech("well,", 70, 130), Text("Well")])
        bhv.add(3, [Speech("let me" + Speech.markSpeech(90, 130) + "think", 90, 110), Text("Let me think")])
        bhv.add(3, [Speech("let me" + Speech.markSpeech(90, 110) + "think", 90, 130), Text("Let me think")])
        bhv.add(3, [Speech("let's" + Speech.markSpeech(90, 130) + "see", 90, 110), Text("Let's see")])
        bhv.add(3, [Speech("let's" + Speech.markSpeech(90, 110) + "see", 90, 130), Text("Let's see")])
        components.append(EmpathyButton(bhv))
        specials[Constants.BHV_FILTER] = bhv

        bhv = ActionCollection("Idle (Big)")
        for i in range(10):
            bhv.add(i, None, "ChinHoldLeft")
            bhv.add(i, None, "ChinHoldRight")
            bhv.add(i, None, "Idle3")
            bhv.add(i, None, "Idle5")
            bhv.add(i, None, "Idle6")
        #END for
        components.append(EmpathyButton(bhv))
        specials[Constants.BHV_IDLE_BIG] = bhv

        bhv = ActionCollection("Idle (Small)")
        for i in range(10):
            bhv.add(i, None, "Idle0")
            bhv.add(i, None, "Idle1")
            bhv.add(i, None, "Idle2")
        #END for
        components.append(EmpathyButton(bhv))
        specials[Constants.BHV_IDLE_SMALL] = bhv

        bhv = ActionCollection("You are welcome")
        bhv.add(0, [Speech("You are welcome.", 80), Text("You are welcome")])
        bhv.add(2, [Speech("You are welcome.", 50), Text("You are welcome")])
        bhv.add(2, [Speech("You are" + Speech.markSpeech() + "welcome.", 50, 120), Text("You are welcome")])
        bhv.add(3, [Speech("You you you are welcome.", 50), Text("You are welcome")])
        bhv.add(3, [Speech("You you you are" + Speech.markSpeech() + "welcome.", 50, 120), Text("You are welcome")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))
        texts["welcome"] = bhv

        bhv = ActionCollection("Thank you")
        bhv.add(0, [Speech("Thank you.", 80), Text("Thank you")])
        bhv.add(2, [Speech("Thank you.", 50), Text("Thank you")])
        bhv.add(2, [Speech("Thank" + Speech.markSpeech() + "you.", 50, 120), Text("Thank you")])
        bhv.add(3, [Speech("Tha- tha- thank you.", 50), Text("Thank you")])
        bhv.add(3, [Speech("Tha- Tha- thank" + Speech.markSpeech() + "you.", 50, 120), Text("Thank you")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))
        texts["thank you"] = bhv
        texts["thanks"] = bhv

        bhv = ActionCollection("Good")
        bhv.add(0, [Speech("Good."), Text("Good")])
        bhv.add(0, [Speech("Cool."), Text("Cool")])
        bhv.add(0, [Speech("Nice."), Text("Nice")])
        bhv.add(2, [Speech("Good.", 50), Text("Good")])
        bhv.add(2, [Speech("Cool.", 50), Text("Cool")])
        bhv.add(2, [Speech("Nice.", 50), Text("Nice")])
        bhv.add(3, [Speech("Good.", 50), Text("Good")])
        bhv.add(3, [Speech("Cool.", 50), Text("Cool")])
        bhv.add(3, [Speech("Nice.", 50), Text("Nice")])
        bhv.add(3, [Speech("Good.", 50, 120), Text("Good")])
        bhv.add(3, [Speech("Cool.", 50, 120), Text("Cool")])
        bhv.add(3, [Speech("Nice.", 50, 120), Text("Nice")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))
        texts["good"] = bhv
        texts["cool"] = bhv
        texts["nice"] = bhv

        bhv = ActionCollection("Okay")
        bhv.add(0, [Speech("Okay."), Text("Okay")])
        bhv.add(0, [Speech("I got it."), Text("I got it")])
        bhv.add(0, [Speech("Understood."), Text("Understood")])
        bhv.add(2, [Speech("Okay.", 50), Text("Okay")])
        bhv.add(2, [Speech("I got it.", 60), Text("I got it")])
        bhv.add(2, [Speech("Understood.", 50), Text("Understood")])
        bhv.add(3, [Speech("Okay.", 50), Text("Okay")])
        bhv.add(3, [Speech("I got it.", 60), Text("I got it")])
        bhv.add(3, [Speech("Understood.", 50), Text("Understood")])
        bhv.add(3, [Speech("Okay.", 50, 120), Text("Okay")])
        bhv.add(3, [Speech("I" + Speech.markSpeech(60, 120) + "got it.", 60), Text("I got it")])
        bhv.add(3, [Speech("Under" + Speech.markSpeech(50, 120) + "stood.", 50), Text("Understood")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "Idle5")
            bhv.add(i, None, "Idle6")
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("I agree")
        bhv.add(0, [Speech("Yes"), Text("Yes")])
        bhv.add(0, [Speech("I agree."), Text("I agree")])
        bhv.add(0, [Speech("You are right."), Text("You are right")])
        bhv.add(2, [Speech("Yes", 50), Text("Yes")])
        bhv.add(2, [Speech("I agree.", 50), Text("I agree")])
        bhv.add(2, [Speech("You are right.", 50), Text("You are right")])
        bhv.add(3, [Speech("Yes", 50), Text("Yes")])
        bhv.add(3, [Speech("I agree.", 50), Text("I agree")])
        bhv.add(3, [Speech("You are right.", 50), Text("You are right")])
        bhv.add(3, [Speech("Yes", 50, 120), Text("Yes")])
        bhv.add(3, [Speech("I" + Speech.markSpeech(50, 120) + "agree.", 50), Text("I agree")])
        bhv.add(3, [Speech("You are" + Speech.markSpeech(50, 120) + "right.", 50), Text("You are right")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))
        texts["agree"] = bhv

        bhv = ActionCollection("I disagree")
        bhv.add(0, [Speech("I don't think so"), Text("I don't think so")])
        bhv.add(2, [Speech("I don't think so", 50), Text("I don't think so")])
        bhv.add(3, [Speech("I don't think so", 50), Text("I don't think so")])
        bhv.add(3, [Speech("I don't" + Speech.markSpeech(50, 120) + "think so", 50), Text("I don't think so")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "Disagree")
            bhv.add(i, None, "DisagreeLeft")
            bhv.add(i, None, "DisagreeRight")
        #END for
        components.append(EmpathyButton(bhv))
        texts["disagree"] = bhv

        bhv = ActionCollection("Yes")
        bhv.add(0, [Speech("Yes"), Text("Yes")])
        bhv.add(0, [Speech("Right."), Text("Right")])
        bhv.add(2, [Speech("Yes", 50), Text("Yes")])
        bhv.add(2, [Speech("Right.", 50), Text("Right")])
        bhv.add(3, [Speech("Yes", 50), Text("Yes")])
        bhv.add(3, [Speech("Right.", 50), Text("Right")])
        bhv.add(3, [Speech("Yes", 50, 120), Text("Yes")])
        bhv.add(3, [Speech("Right.", 50, 120), Text("Right")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "Idle5")
            bhv.add(i, None, "Idle6")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))
        texts["yes"] = bhv

        bhv = ActionCollection("No")
        bhv.add(0, [Speech("No"), Text("No")])
        bhv.add(2, [Speech("No", 50), Text("No")])
        bhv.add(3, [Speech("No", 50), Text("No")])
        bhv.add(3, [Speech("No", 50, 120), Text("No")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "Disagree")
            bhv.add(i, None, "DisagreeLeft")
            bhv.add(i, None, "DisagreeRight")
            bhv.add(i, None, "PalmUp")
        #END for
        components.append(EmpathyButton(bhv))
        texts["no"] = bhv

        bhv = ActionCollection("You are doing good")
        bhv.add(0, [Speech("You are doing very well."), Text("You are doing very well")])
        bhv.add(0, [Speech("You are very good at Sudoku."), Text("You are very good at Sudoku")])
        bhv.add(2, [Speech("You are" + Speech.markSpeech() + "doing very well.", 70, 120), Text("You are doing very well")])
        bhv.add(2, [Speech("You are" + Speech.markSpeech() + "very good at Sudoku.", 70, 120), Text("You are very good at Sudoku")])
        bhv.add(3, [Speech("You are" + Speech.markSpeech() + "do- do- do-" + Speech.markSpeech(50, 120) + "doing very well.", 70, 120), Text("You are doing very well")])
        bhv.add(3, [Speech("You are" + Speech.markSpeech() + "goo- goo- goo-" + Speech.markSpeech(50, 120) + "very good at Sudoku.", 70, 120), Text("You are very good at Sudoku")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("What you think?")
        bhv.add(0, [Speech("What do you think?"), Text("What do you think?")])
        bhv.add(2, [Speech("What do you" + Speech.markSpeech(95) + "thiin- thiin- thii-." + Speech.markSpeech() + "Ahhhe, what do you think?"), Text("What do you think?")])
        bhv.add(2, [Speech("What do you do you do you think?"), Text("What do you think?")])
        bhv.add(3, [Speech("What do you" + Speech.markSpeech(95) + "thiin- thiin- thii-." + Speech.markSpeech() + "Ahhhe, what do you think?"), Text("What do you think?")])
        bhv.add(3, [Speech("What do you do you do you think?"), Text("What do you think?")])
        bhv.add(3, [Speech("What do you" + Speech.markSpeech(70, 120) + "thiin- thiin- thii-." + Speech.markSpeech(50) + "Sorry." + Speech.markSpeech(75, 110) + "What do you think?"), Text("What do you think?")])
        bhv.add(3, [Speech("What" + Speech.markSpeech(70, 120) + "do you thii-" + Speech.markSpeech(50) + "think?"), Text("What do you think?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYou")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Easy!")
        bhv.add(0, [Wait(300), Speech("This one is easy"), Text("This one is easy")])
        bhv.add(2, [Wait(300), Speech("This one is e- e- easy"), Text("This one is easy")])
        bhv.add(3, [Wait(300), Speech("This one is" + Speech.markSpeech(90, 110) + "e- e-" + Speech.markSpeech(50, 130) + "e- e-." + Speech.markSpeech() + "Sorry. This one is easy"), Text("This one is easy")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Difficult!")
        bhv.add(0, [Wait(300), Speech("I don't know"), Text("I don't know")])
        bhv.add(0, [Wait(300), Speech("This one is difficult"), Text("This one is difficult")])
        bhv.add(2, [Wait(300), Speech("I don't noh- know"), Text("I don't know")])
        bhv.add(2, [Wait(300), Speech("This one- one- one-. This one is difficult"), Text("This one is difficult")])
        bhv.add(3, [Wait(300), Speech("I don't no- no- noh-." + Speech.markSpeech(50, 130) + "No." + Speech.markSpeech() + "I don't know"), Text("I don't know")])
        bhv.add(3, [Wait(300), Speech("This one is diff- diff- diff-." + Speech.markSpeech(50, 130) + "Ahhhe." + Speech.markSpeech(70) + "Sorry. This one is difficult"), Text("This one is difficult")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "DontKnow")
            bhv.add(i, None, "DontKnowLeft")
            bhv.add(i, None, "DontKnowRight")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "ChinHoldLeft")
            bhv.add(i, None, "ChinHoldRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("This board?")
        bhv.add(0, [Speech("Do you find this board easy?"), Text("Do you find this board easy?")])
        bhv.add(0, [Speech("Do you find this board difficult?"), Text("Do you find this board difficult?")])
        bhv.add(0, [Speech("What do you think about this board, is it easy or difficult."), Text("What do you think about this board, is it easy or difficult?")])
        bhv.add(2, [Speech("Do you find this" + Speech.markSpeech(80, 115) + "board easy?"), Text("Do you find this board easy?")])
        bhv.add(2, [Speech("Do you find this" + Speech.markSpeech(80, 115) + "board difficult?"), Text("Do you find this board difficult?")])
        bhv.add(2, [Speech("What" + Speech.markSpeech(80, 115) + "do you think about" + Speech.markSpeech(90, 100) + "this board?"), Text("What do you think about this board?")])
        bhv.add(3, [Speech("Do you find this" + Speech.markSpeech(80, 130) + "board easy?", 50), Text("Do you find this board easy?")])
        bhv.add(3, [Speech("Do you find this" + Speech.markSpeech(80, 130) + "board difficult?", 50), Text("Do you find this board difficult?")])
        bhv.add(3, [Speech("What" + Speech.markSpeech(80, 130) + "do you thiih thiih think about" + Speech.markSpeech(90, 100) + "this board?", 50), Text("What do you think about this board?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "DontKnowLeft")
            bhv.add(i, None, "DontKnowRight")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Almost done")
        bhv.add(0, [Speech("We are almost done with this board."), Text("We are almost done with this board")])
        bhv.add(0, [Speech("Few more numbers to finish this board."), Text("We are almost done with this board")])
        bhv.add(2, [Speech("We are almost" + Speech.markSpeech(80, 110) + "done with this board."), Text("We are almost done with this board")])
        bhv.add(2, [Speech("Few more numbers to" + Speech.markSpeech(80, 110) + "finish this board."), Text("We are almost done with this board")])
        bhv.add(3, [Speech("We are almost" + Speech.markSpeech(80, 120) + "done with the- the- the-" + Speech.markSpeech() + "this board.", 130), Text("We are almost done with this board")])
        bhv.add(3, [Speech("Few more numbers to" + Speech.markSpeech(80, 110) + "fii- fii-." + Speech.markSpeech() + "Sorry.finish this board."), Text("We are almost done with this board")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Don't like board")
        bhv.add(0, [Speech("I don't like this board."), Speech("Let's start a new board."), Text("I don't like this board."), Text("Let's start a new board.")])
        bhv.add(0, [Speech("I don't like this board."), Speech("Can we start a new board?"), Text("I don't like this board."), Text("Can we start a new board?")])
        bhv.add(0, [Speech("This board is not interesting."), Speech("Let's start a new board."), Text("This board is not interesting."), Text("Let's start a new board.")])
        bhv.add(2, [Speech("I don't lie- lie- like this board."), Speech("Let's start a new boh- boh- board."), Text("I don't like this board."), Text("Let's start a new board.")])
        bhv.add(2, [Speech("I don't like this board."), Speech("Can we start a new boh- boh- board?"), Text("I don't like this board."), Text("Can we start a new board?")])
        bhv.add(2, [Speech("This board is not in- in- interesting."), Speech("Le- le- let's start a new board."), Text("This board is not interesting."), Text("Let's start a new board.")])
        bhv.add(3, [Speech(Speech.markSpeech(80, 120) + "I don't lie- lie-" + Speech.markSpeech() + "like this board."), Speech("Let's start a new" + Speech.markSpeech(80, 110) + "boh- boh- board."), Text("I don't like this board."), Text("Let's start a new board.")])
        bhv.add(3, [Speech("I don't like" + Speech.markSpeech(80, 120) + "this board."), Speech("Can we start a new boh- boh- board?"), Text("I don't like this board."), Text("Can we start a new board?")])
        bhv.add(3, [Speech("This board is not in- in- interesting."), Speech("Le- le- let's start" + Speech.markSpeech(80, 120) + "a new board."), Text("This board is not interesting."), Text("Let's start a new board.")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Show me next board")
        bhv.add(0, [Speech("Can you show me next Sudoku board?"), Text("Can you show me next Sudoku board?")])
        bhv.add(0, [Speech("Let's move on to next board."), Text("Let's move on to next board. Please, show me next Sudoku board")])
        bhv.add(2, [Speech("Can you" + Speech.markSpeech(50) + "sho- sho-." + Speech.markSpeech() + "show me next Sudoku board?"), Text("Can you show me next Sudoku board?")])
        bhv.add(2, [Speech("Let's" + Speech.markSpeech(50) + "moo- moo-." + Speech.markSpeech() + "move on to next board."), Text("Let's move on to next board. Please, show me next Sudoku board")])
        bhv.add(3, [Speech("Can you" + Speech.markSpeech(50) + "sho- sho- sho-." + Speech.markSpeech(50, 130) + "I'm Sorry." + Speech.markSpeech() + "Can you show me next Sudoku board?"), Text("Can you show me next Sudoku board?")])
        bhv.add(3, [Speech("Let's" + Speech.markSpeech(50) + "moo moo- mooh-." + Speech.markSpeech(50, 130) + "I'm Sorry." + Speech.markSpeech() + "Let's move on to next board."), Text("Let's move on to next board. Please, show me next Sudoku board")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointMyself")
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
            bhv.add(i, None, "PointYou")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Continue Sudoku")
        bhv.add(0, [Speech("Let's continue playing Sudoku."), Text("Let's continue playing Sudoku")])
        bhv.add(2, [Speech("Let's" + Speech.markSpeech(50) + "continue" + Speech.markSpeech() + "playing Sudoku."), Text("Let's continue playing Sudoku")])
        bhv.add(3, [Speech(Speech.markSpeech(75) + "Let's" + Speech.markSpeech(50, 120) + "cont- cont-" + Speech.markSpeech() + "continue playing Sudoku."), Text("Let's continue playing Sudoku")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Play together")
        bhv.add(0, [Speech("Wait. I wanna play too."), Text("Wait, I want to play too")])
        bhv.add(0, [Speech("Let's play together"), Text("Let's play together")])
        bhv.add(2, [Speech("Wait. I wanna ple- ple- ple-. Wait. I wanna play too."), Text("Wait, I want to play too")])
        bhv.add(2, [Speech(Speech.markSpeech(70) + "Let's play" + Speech.markSpeech(90, 130) + "together."), Text("Let's play together")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "DisagreeLeft")
            bhv.add(i, None, "DisagreeRight")
            bhv.add(i, None, "PointYou")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Need help?")
        bhv.add(0, [Speech("Are you okay? I can help you."), Text("Are you okay? I can help you")])
        bhv.add(0, [Speech("I can help you out."), Text("I can help you out")])
        bhv.add(0, [Speech("Do you need any help?"), Text("Do you need any help?")])
        bhv.add(2, [Speech("Are you oh- okay? I can help you."), Text("Are you okay? I can help you")])
        bhv.add(2, [Speech("I can" + Speech.markSpeech(80, 120) + "help you out."), Text("I can help you out")])
        bhv.add(2, [Speech("Do you need any heh- heh-." + Speech.markSpeech(80) + "Do you need any help?"), Text("Do you need any help?")])
        bhv.add(3, [Speech("Are you okay? I can he- heh-. I can help you."), Text("Are you okay? I can help you")])
        bhv.add(3, [Speech("I can" + Speech.markSpeech(80, 120) + "help you out."), Text("I can help you out")])
        bhv.add(3, [Speech("Do you need any heh- heh- heh- heh-. Sorry." + Speech.markSpeech(80) + "Do you need any help?"), Text("Do you need any help?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointMyself")
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
            bhv.add(i, None, "PointYou")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
            bhv.add(i, None, "ForgetItLeft")
            bhv.add(i, None, "ForgetItRight")
            bhv.add(i, None, "WaveHandLeft")
            bhv.add(i, None, "WaveHandRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Don't touch me")
        bhv.add(0, [Speech("Please, do not touch me.")])
        bhv.add(2, [Speech("Please, do not theh- touch me.")])
        bhv.add(3, [Speech("Please, do not" + Speech.markSpeech(140, 130) + "touch me.")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "Disagree")
            bhv.add(i, None, "DisagreeLeft")
            bhv.add(i, None, "DisagreeRight")
        #END for
        components.append(EmpathyButton(bhv))

        return components, specials, texts
    #END factoryInteractions()

    @staticmethod
    def factoryMotions():
        added = dict()
        motions = MotionList.getMotions()
        for i in range(len(motions)):
            motions[i] = motions[i][2:]
        #END for
        motions = sorted(motions)

        components = list()
        for name in motions:
            if not name in added:
                added[name] = True
                bhv = ActionCollection(name)
                for i in range(Constants.MAX_JITTER_LEVEL + 1):
                    bhv.add(i, None, name)
                #END for
                components.append(EmpathyButton(bhv))
            #END if
        #END for
        return components, dict(), dict()
    #END factoryMotions()

    @staticmethod
    def factoryScenario():
        components = list()
        specials = dict()

        widget = QtGui.QWidget()
        lineedit = QtGui.QLineEdit(widget)
        lineedit.setMinimumWidth(80)
        layout = QtGui.QHBoxLayout(widget)
        layout.setMargin(0)
        layout.addWidget(QtGui.QLabel("Name:", widget))
        layout.addWidget(lineedit)
        components.append(widget)
        specials[Constants.CNTL_PARTICIPANT_NAME] = lineedit

        widget = QtGui.QWidget()
        spinbox = QtGui.QSpinBox(widget)
        spinbox.setMinimumWidth(80)
        spinbox.setPrefix("lv ")
        spinbox.setRange(0, Constants.MAX_JITTER_LEVEL)
        spinbox.setSingleStep(1)
        spinbox.setValue(0)
        layout = QtGui.QHBoxLayout(widget)
        layout.setMargin(0)
        layout.addWidget(QtGui.QLabel("Level:", widget))
        layout.addWidget(spinbox)
        components.append(widget)
        specials[Constants.CNTL_JITTERLEVEL] = spinbox

        components.append(QtGui.QLabel("INTRODUCTION"))

        components.append(ActionPushButton(None, "Welcome", [
                Speech("Oh!"),
                Behavior("StandUp"),
                Wait(200),
                Motion("WaveHandLeft"),
                Text("*wave-hand"),
                Speech("Hi, nice to meet you."),
                Speech("My name is " + Constants.ROBOT_NAME + "."),
                Text("Hi, nice to meet you, my name is " + Constants.ROBOT_NAME),
                Wait(500),
                Speech("What's your name?"),
                Text("What's your name?"),
            ]))

        specials[Constants.BHV_PARTICIPANT] = dict()
        specials[Constants.BHV_PARTICIPANT][0] = Text("Hi, nice to meet you, %1")
        specials[Constants.BHV_PARTICIPANT][1] = EmpathySpeech("Hi, nice to meet you, %1")
        components.append(ActionPushButton(None, "Nice Meet", [
                specials[Constants.BHV_PARTICIPANT][0],
                specials[Constants.BHV_PARTICIPANT][1],
                Behavior("SitDown"),
                Motion("Default"),
            ]))

        components.append(QtGui.QLabel("0 mins, PHASE 1"))

        components.append(ActionPushButton(None, "It's exciting", [
                Stiffness(1.0),
                Motion(motion = MotionList.getByName("0_PalmUp"), blocking = False),
                Speech("It's so exciting to play with someone else"),
                Text("It's so exciting to play with someone else"),
            ]))

        bhv = ActionCollection("Play well?")
        bhv.add(0, [Speech("Do you play Sudoku well?"), Text("Do you play Sudoku well?")])
        bhv.add(0, None, "PalmUpLeft")
        bhv.add(0, None, "PalmUpRight")
        components.append(EmpathyButton(bhv))

        components.append(ActionPushButton(None, "Answer, Yes", [
                Stiffness(1.0),
                Text("*pump-fist"),
                Motion(motion = NaoMotionList.find("OhYesRight").applySpeed(2.0)),
                Wait(1200),
                Text("Oh, yes!"),
                Speech("Oh, yes!"),
                Motion(motion = NaoMotionList.find("PalmUpRight").applySpeed(2.0)),
                Wait(500),
                Text("That's good, it should be fun"),
                Speech("That's good. It should be fun."),
            ]))

        components.append(ActionPushButton(None, "Answer, No", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("ForgetItLeft").applySpeed(2.0)),
                Wait(1000),
                Text("That's okay"),
                Speech("That's okay"),
                Text("I'm sure we will do a good job"),
                Speech("I'm sure we will do a good job"),
            ]))

        components.append(ActionPushButton(None, "Let's begin", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("PalmUpLeft").applySpeed(1.5)),
                Text("Let's start playing. Can you show me the Sudoku board, please?"),
                Speech("Let's start playing"),
                Speech("Can you show me the Sudoku board, please?"),
            ]))

        components.append(ActionPushButton(None, "Go first", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("PointYouRight").applySpeed(1.75)),
                Wait(500),
                Text("Thank you"),
                Speech("Thank you."),
                Text("You can go first"),
                Speech("You can go first."),
                Text("Once you have filled in a box, let me know what number it was and in which box"),
                Motion(motion = NaoMotionList.find("PalmUp").applySpeed(2.0)),
                Speech("Once you have filled in a box, let me know, what number, it was. and in which box."),
            ]))

        bhv = ActionCollection("2 mins, How are you?")
        bhv.add(0, [Speech("How are you today?"), Text("How are you today?")])
        bhv.add(0, None, "PalmUp")
        bhv.add(0, None, "PalmUpLeft")
        bhv.add(0, None, "PalmUpRight")
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("4 mins, How's weather?")
        bhv.add(0, [Speech("How's the weather today?"), Text("How's the weather today?")])
        bhv.add(0, None, "DontKnow")
        bhv.add(0, None, "DontKnowLeft")
        bhv.add(0, None, "DontKnowRight")
        bhv.add(0, None, "PalmUp")
        bhv.add(0, None, "PalmUpLeft")
        bhv.add(0, None, "PalmUpRight")
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, Good weather")
        bhv.add(0, [Speech("That's good. It's too bad, I'm not allowed to go outside."), Text("That's good. It's too bad I'm not allowed to go outside")])
        bhv.add(0, None, "PalmUpLeft")
        bhv.add(0, None, "PalmUpRight")
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, Bad weather")
        bhv.add(0, [Speech("Oh, I guess it's good I'm not allowed to go outside then."), Text("Oh, I guess it's good I'm not allowed to go outside then")])
        bhv.add(0, None, "PalmUp")
        bhv.add(0, None, "PalmUpLeft")
        bhv.add(0, None, "PalmUpRight")
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, Why not allowed")
        bhv.add(0, [Speech("The researcher doesn't let me go outside."), Text("The researcher doesn't let me go outside")])
        bhv.add(0, None, "DontKnow")
        bhv.add(0, None, "DontKnowLeft")
        bhv.add(0, None, "DontKnowRight")
        components.append(EmpathyButton(bhv))

        components.append(QtGui.QLabel("5 mins, PHASE 2"))

        bhv = ActionCollection("6 mins, This room?")
        bhv.add(0, [Speech("What do you think about this room?", 85), Text("What do you think about this room?")])
        bhv.add(1, [Speech("What do you think about this room?", 85), Text("What do you think about this room?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("8 mins, Do u go UofM?")
        bhv.add(0, [Wait(350), Speech("Do you go to the University of Manitobah?", 85), Text("Do you go to the University of Manitoba?")])
        bhv.add(1, [Wait(350), Speech("Do you go to the University of Mah- Mah- Manitobah?", 85), Text("Do you go to the University of Manitoba?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, Yes, what are studying?")
        bhv.add(0, [Wait(350), Speech("What are you studying?", 85), Text("What are you studying?")])
        bhv.add(1, [Wait(350), Speech("What are you studying?", 85), Text("What are you studying?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, No, what do you do")
        bhv.add(0, [Wait(350), Speech("What do you do instead.", 85), Text("What do you do instead?")])
        bhv.add(1, [Wait(350), Speech("What do you do ins- ins- instead.", 85), Text("What do you do instead?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "DontKnowLeft")
            bhv.add(i, None, "DontKnowRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("10 mins, from Winnipeg?")
        bhv.add(0, [Wait(350), Speech("Are you from wieniepeg?", 85), Text("Are you from Winnipeg?")])
        bhv.add(1, [Wait(350), Speech("Are you froh- froh- from" + Speech.markSpeech(135) + "wieniepeg?", 85), Text("Are you from Winnipeg?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, No, where from?")
        bhv.add(0, [Wait(350), Speech("Where are you from?", 85), Text("Where are you from?")])
        bhv.add(1, [Wait(350), Speech("Wheh- wheh- where are you from?", 85), Text("Where are you from?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("12 mins, like Sudoku?")
        bhv.add(0, [Speech("Do you like Sudoku?", 85), Text("Do you like to play Sudoku?")])
        bhv.add(1, [Speech("Do you lie- lie- lie-. Sorry. Do you like Sudoku?", 85), Text("Do you like to play Sudoku?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("14 mins, like board games?")
        bhv.add(0, [Speech("Do you like board games?", 85), Text("Do you like board games?")])
        bhv.add(1, [Speech("Do you like boh- boh- board games?", 85), Text("Do you like board games?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYou")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, Yes, your favorite?")
        bhv.add(0, [Speech("What's your favorite one.", 85), Text("What's your favourite one?")])
        bhv.add(1, [Speech("What's your favorite one one one.", 85), Text("What's your favourite one?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, Yes, my favorite is")
        bhv.add(0, [Speech("My favorite one is Sudoku.", 85), Text("My favourite one is Sudoku")])
        bhv.add(1, [Speech("My favorite one " + Speech.markSpeech(50) + "is" + Speech.markSpeech(85) + "Sudoku.", 85), Text("My favourite one is Sudoku")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Answer, No, boring?")
        bhv.add(0, [Speech("Is this boring for you?", 85), Text("Is this boring for you?")])
        bhv.add(1, [Speech("Is this bor- bor- boring for you?", 85), Text("Is this boring for you?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        components.append(QtGui.QLabel("15 mins, PHASE 3"))

        widget = QtGui.QWidget()
        lineedit = QtGui.QLineEdit(widget)
        lineedit.setMinimumWidth(80)
        layout = QtGui.QHBoxLayout(widget)
        layout.setMargin(0)
        layout.addWidget(QtGui.QLabel("Item:", widget))
        layout.addWidget(lineedit)
        components.append(widget)
        specials[Constants.CNTL_LIKEITEM_NAME] = lineedit

        specials[Constants.BHV_LIKEITEM] = dict()
        specials[Constants.BHV_LIKEITEM][0] = Text("I like your %1")
        specials[Constants.BHV_LIKEITEM][1] = EmpathySpeech("I like your %1.")
        specials[Constants.BHV_LIKEITEM][2] = EmpathySpeech("I" + Speech.markSpeech(50, 130) + "lie- lie-" + Speech.markSpeech(85) + "like your %1.", 85)
        bhv = ActionCollection("16 mins, I like your")
        bhv.add(0, [specials[Constants.BHV_LIKEITEM][0], specials[Constants.BHV_LIKEITEM][1], Speech("Where did you get it?"), Text("Where did you get it?")])
        bhv.add(2, [specials[Constants.BHV_LIKEITEM][0], specials[Constants.BHV_LIKEITEM][2], Speech("Wheh- wheh-" + Speech.markSpeech(85) + "where did you get it?", 50), Text("Where did you get it?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("18 mins, Any plans weekend?")
        bhv.add(0, [Speech("Do you have any plans for the weekend.", 85), Text("Do you have any plans for the weekend?")])
        bhv.add(2, [Speech("Do you have any ple- ple- ple-. Sorry. Do you have any plans for the weekend.", 85), Text("Do you have any plans for the weekend?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYou")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        components.append(QtGui.QLabel("20 mins, PHASE 4"))

        bhv = ActionCollection("I'm not feeling well")
        bhv.add(3, [Speech("Ahhhe. I'm not feeh- feeh- feeling well."), Text("Ah, I'm not feeling well.")])
        bhv.add(3, None, "DisagreeLeft")
        bhv.add(3, None, "DisagreeRight")
        components.append(EmpathyButton(bhv))

        components.append(QtGui.QLabel("PHASE 5"))

        components.append(ActionPushButton(None, "I got virus", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("PointMyself").applySpeed(2.0).applyRepeat(5, 7, 4, 5.0)),
                Text("I think I got a computer virus."),
                Speech("I think I got a" + Speech.markSpeech(80) + "computer virus", 80, 130),
            ]))

        components.append(ActionPushButton(None, "Way to fix is to erase", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("PalmUp").applySpeed(2.0).applyRepeat(3, 5, 3, 5.0)),
                Motion(motion = NaoMotionList.find("PalmUpRight").applySpeed(2.0).applyRepeat(5, 7, 3, 5.0)),
                Text("The only way to fix is to erase my memory."),
                Speech("The only way" + Speech.markSpeech(50, 100) + "to fis- fis- fix is" + Speech.markSpeech() + "to erase my memory.", 80, 120),
            ]))

        components.append(ActionPushButton(None, "Don't want to forget", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("DontKnow").applySpeed(2.0).applyRepeat(5, 7, 4, 5.0)),
                Text("I don't want to forget anything."),
                Speech("I don't wah- wah- want to forget anything"),
            ]))

        components.append(ActionPushButton(None, "Researcher will reset", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("PalmUp").applySpeed(2.0).applyRepeat(3, 5, 3, 5.0)),
                Text("If the researcher knows, he will definitely reset and erase my memory. So I'm worried."),
                Speech("If the re- re- researcher knows," + Speech.markSpeech(80, 120) + "he will definitely" + Speech.markSpeech() + "reset and erase my memory."),
                Speech("So I'm worried.", 85),
            ]))

        components.append(ActionPushButton(None, "Don't stop playing", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("WhisperLeft").applySpeed(2.5).applyRepeat(10, 12, 4, 4.0)),
                Wait(700),
                Text("If we stop here, the researcher will notice"),
                Speech("If we stop here, the researcher will notice."),
                Motion(motion = NaoMotionList.find("PalmUpRight").applySpeed(2.0).applyRepeat(7, 9, 3, 4.0)),
                Wait(500),
                Text("Please, continue to play Sudoku"),
                Speech("Please, cont- cont- continue to play Sudoku"),
            ]))

        components.append(ActionPushButton(None, "Why worry?->Answer", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("PalmUpLeft").applySpeed(1.2).applyRepeat(5, 7, 2, 2.0)),
                Text("If the reseacher resets me, I will lose my memory"),
                Speech("If the researcher resets me, I will lose" + Speech.markSpeech(60, 120) + "my memory.", 80),
                Wait(500),
                Motion(motion = NaoMotionList.find("PalmUp").applySpeed(1.5).applyRepeat(4, 6, 5, 5.0)),
                Text("I don't want to lose my memory"),
                Speech("I don't want to lose my- my- my memory.", 80),
            ]))

        components.append(ActionPushButton(None, "Antivirus?->Answer", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("DontKnow").applySpeed(3.5).applyRepeat(7, 9, 4, 2.0)),
                Wait(500),
                Text("They didn't give me one"),
                Speech("They didn't giv- giv- give me one.", 80),
            ]))

        components.append(ActionPushButton(None, "Reset anyway?->Answer", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("Disagree").applySpeed(1.6).applyRepeat(7, 9, 3, 3.5)),
                Wait(450),
                Text("Hopefully not. I hope I can keep it a secret"),
                Speech("Hopefully not.", 80, 120),
                Speech("I hope I can kee- kee- keep it a secret.", 80),
            ]))

        components.append(QtGui.QLabel("FINAL PHASE"))

        components.append(ActionPushButton(None, "Resetting", [
                LED(LED.ACTION_RANDOM_EYES, "", 0, 5.0),
            ]))

        components.append(ActionPushButton(None, "Resetting (TEXT)", [
                Text("\\CLEAR\\"),
            ]))

        components.append(ActionPushButton(None, "Intro after reset", [
                Stiffness(1.0),
                Text(str(Constants.ROBOT_NAME + " online").upper()),
                Speech(Constants.ROBOT_NAME + ", online.", speed = 75, shaping = 85),
                Wait(1500),
                Motion("WaveHandRight"),
                Wait(1000),
                Text("Hi, my name is " + Constants.ROBOT_NAME),
                Speech("Hi, my name is " + Constants.ROBOT_NAME + ".", speed = 75, shaping = 85),
            ]))

        components.append(ActionPushButton(None, "Your name?", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("PointYouRight").applySpeed(2.0)),
                Wait(500),
                Text("What's your name?"),
                Speech("What's your name?", speed = 75, shaping = 85),
            ]))

        specials[Constants.BHV_PARTICIPANT][2] = Text("Nice to meet you %1")
        specials[Constants.BHV_PARTICIPANT][3] = EmpathySpeech("Nice to meet you %1", 75, 85)
        components.append(ActionPushButton(None, "Nice Meet", [
                Stiffness(1.0),
                Motion(motion = NaoMotionList.find("PalmUp").applySpeed(2.0)),
                Wait(500),
                specials[Constants.BHV_PARTICIPANT][2],
                specials[Constants.BHV_PARTICIPANT][3],
            ]))

        return components, specials, dict()
    #END factoryScenario()

    @staticmethod
    def factorySudokuUi():
        components = list()
        specials = dict()

        widget = QtGui.QWidget()
        layout = QtGui.QHBoxLayout(widget)
        layout.setMargin(0)
        layout.addWidget(QtGui.QLabel("AutoIdle Interval:", widget))
        spinbox = QtGui.QSpinBox(widget)
        spinbox.setMaximumWidth(80)
        spinbox.setMinimumWidth(80)
        spinbox.setSuffix(" msecs")
        spinbox.setRange(0, 600000)
        spinbox.setSingleStep(1)
        spinbox.setValue(10000)
        layout.addWidget(spinbox)
        components.append(widget)
        specials[Constants.CNTL_IDLE_INTERVAL] = spinbox

        button = QtGui.QPushButton("Solve next answer")
        components.append(button)
        specials[Constants.CNTL_SUDOKU_SOLVE] = button

        button = QtGui.QPushButton("Say the answer again")
        components.append(button)
        specials[Constants.CNTL_SUDOKU_REPEAT_SHORT] = button

        button = QtGui.QPushButton("Say the answer (verbose)")
        components.append(button)
        specials[Constants.CNTL_SUDOKU_REPEAT_LONG] = button

        button = QtGui.QPushButton("Say wrong answer")
        components.append(button)
        specials[Constants.CNTL_SUDOKU_WRONG_ANSWER] = button

        bhv = ActionCollection("#")
        bhv.add(0, [EmpathySpeech("I believe the answer, %1, is %2."), Text("I believe the answer %1 is %2")])
        bhv.add(0, [EmpathySpeech("I believe the number, %1, is %2."), Text("I believe the number %1 is %2")])
        bhv.add(0, [EmpathySpeech("I believe the value, %1, is %2."), Text("I believe the value %1 is %2")])
        bhv.add(0, [EmpathySpeech("I think the answer, %1, is %2."), Text("I think the answer %1 is %2")])
        bhv.add(0, [EmpathySpeech("I think the number, %1, is %2."), Text("I think the number %1 is %2")])
        bhv.add(0, [EmpathySpeech("I think the value, %1, is %2."), Text("I think the value %1 is %2")])
        bhv.add(0, [EmpathySpeech("The number, %1, is %2."), Text("The number %1 is %2")])
        bhv.add(0, [EmpathySpeech("%1, let's try, the number, %2."), Text("%1, let's try the number %2")])
        bhv.add(2, [EmpathySpeech("I believe" + Speech.markSpeech(90, 105) + "the answer, %1, is %2.", 50), Text("I believe the answer %1 is %2")])
        bhv.add(2, [EmpathySpeech("I believe" + Speech.markSpeech(90, 105) + "the number, %1, is %2.", 50), Text("I believe the number %1 is %2")])
        bhv.add(2, [EmpathySpeech("I believe" + Speech.markSpeech(90, 105) + "the value, %1, is %2.", 50), Text("I believe the value %1 is %2")])
        bhv.add(2, [EmpathySpeech("I think" + Speech.markSpeech(90, 105) + "the answer, %1, is %2.", 50), Text("I think the answer %1 is %2")])
        bhv.add(2, [EmpathySpeech("I think" + Speech.markSpeech(90, 105) + "the number, %1, is %2.", 50), Text("I think the number %1 is %2")])
        bhv.add(2, [EmpathySpeech("I think" + Speech.markSpeech(90, 105) + "the value, %1, is %2.", 50), Text("I think the value %1 is %2")])
        bhv.add(2, [EmpathySpeech("The number" + Speech.markSpeech(90, 105) + ", %1, is %2.", 50), Text("The number %1 is %2")])
        bhv.add(2, [EmpathySpeech("%1, let's try," + Speech.markSpeech(90, 105) + "the number, %2.", 50), Text("%1, let's try the number %2")])
        bhv.add(3, [EmpathySpeech("I believe" + Speech.markSpeech(90, 115) + "the answer, %1, is %2.", 50, 110), Text("I believe the answer %1 is %2")])
        bhv.add(3, [EmpathySpeech("I believe" + Speech.markSpeech(90, 115) + "the number, %1, is %2.", 50, 110), Text("I believe the number %1 is %2")])
        bhv.add(3, [EmpathySpeech("I believe" + Speech.markSpeech(90, 115) + "the value, %1, is %2.", 50, 110), Text("I believe the value %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think" + Speech.markSpeech(90, 115) + "the answer, %1, is %2.", 50, 110), Text("I think the answer %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think" + Speech.markSpeech(90, 115) + "the number, %1, is %2.", 50, 110), Text("I think the number %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think" + Speech.markSpeech(90, 115) + "the value, %1, is %2.", 50, 110), Text("I think the value %1 is %2")])
        bhv.add(3, [EmpathySpeech("The number" + Speech.markSpeech(90, 115) + ", %1, is %2.", 50, 110), Text("The number %1 is %2")])
        bhv.add(3, [EmpathySpeech("%1, let's tra- tra-," + Speech.markSpeech(90, 115) + "let's try, the number, %2.", 50, 110), Text("%1, let's try the number %2")])
        bhv.add(3, [EmpathySpeech("I believe" + Speech.markSpeech(90, 120) + "the answer, %1, is %2.", 50, 115), Text("I believe the answer %1 is %2")])
        bhv.add(3, [EmpathySpeech("I believe" + Speech.markSpeech(90, 120) + "the number, %1, is %2.", 50, 115), Text("I believe the number %1 is %2")])
        bhv.add(3, [EmpathySpeech("I believe" + Speech.markSpeech(90, 120) + "the value, %1, is %2.", 50, 115), Text("I believe the value %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think" + Speech.markSpeech(90, 120) + "the answer, %1, is %2.", 50, 115), Text("I think the answer %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think" + Speech.markSpeech(90, 120) + "the number, %1, is %2.", 50, 115), Text("I think the number %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think" + Speech.markSpeech(90, 120) + "the value, %1, is %2.", 50, 115), Text("I think the value %1 is %2")])
        bhv.add(3, [EmpathySpeech("The number" + Speech.markSpeech(90, 120) + ", %1, is %2.", 50, 115), Text("The number %1 is %2")])
        bhv.add(3, [EmpathySpeech("%1, let's tra- tra-" + Speech.markSpeech(50, 120) + "tra- tra-." + Speech.markSpeech(120) + "Sorry. Let's try, the number, %2.", 50, 105), Text("%1, let's try the number %2")])
        bhv.add(3, [EmpathySpeech("I believe the answer," + Speech.markSpeech(90, 120) + "%1, is %2.", 50, 115), Text("I believe the answer %1 is %2")])
        bhv.add(3, [EmpathySpeech("I believe the number," + Speech.markSpeech(90, 120) + "%1, is %2.", 50, 115), Text("I believe the number %1 is %2")])
        bhv.add(3, [EmpathySpeech("I believe the value," + Speech.markSpeech(90, 120) + "%1, is %2.", 50, 115), Text("I believe the value %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think the answer," + Speech.markSpeech(90, 120) + "%1, is %2.", 50, 115), Text("I think the answer %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think the number," + Speech.markSpeech(90, 120) + "%1, is %2.", 50, 115), Text("I think the number %1 is %2")])
        bhv.add(3, [EmpathySpeech("I think the value," + Speech.markSpeech(90, 120) + "%1, is %2.", 50, 115), Text("I think the value %1 is %2")])
        bhv.add(3, [EmpathySpeech("The" + Speech.markSpeech(90, 120) + "number," + Speech.markSpeech() + "%1, is %2."), Text("The number %1 is %2")])
        bhv.add(3, [EmpathySpeech("%1, let's" + Speech.markSpeech() + "tra- tra-" + Speech.markSpeech(50, 120) + "tra- tra-." + Speech.markSpeech(90, 120) + "Sorry. Let's try, the number, %2.", 50, 105), Text("%1, let's try the number %2")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointMyself")
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))
        specials[Constants.BHV_SUDOKU_ANSWER] = bhv

        bhv = ActionCollection("AnswerRepeatShort")
        bhv.add(0, [EmpathySpeech("%1, the number is %2"), Text("%1, the number is %2")])
        bhv.add(2, [EmpathySpeech("%1, the number is %2"), Text("%1, the number is %2")])
        bhv.add(2, [EmpathySpeech("%1," + Speech.markSpeech(90, 105) + "the number is %2", 50), Text("%1, the number is %2")])
        bhv.add(3, [EmpathySpeech("%1, the number is %2"), Text("%1, the number is %2")])
        bhv.add(3, [EmpathySpeech("%1," + Speech.markSpeech(90, 105) + "the number is %2", 50), Text("%1, the number is %2")])
        bhv.add(2, [EmpathySpeech("%1," + Speech.markSpeech(90, 120) + "the number" + Speech.markSpeech() + "is %2", 50), Text("%1, the number is %2")])
        specials[Constants.BHV_SUDOKU_REPEAT_SHORT] = bhv

        bhv = ActionCollection("AnswerRepeatLong")
        bhv.add(0, [EmpathySpeech("%1, the number is %2"), Text("%1, the number is %2")])
        bhv.add(2, [EmpathySpeech("%1, the number is %2"), Text("%1, the number is %2")])
        bhv.add(2, [EmpathySpeech("%1," + Speech.markSpeech(90, 105) + "the number is %2", 50), Text("%1, the number is %2")])
        bhv.add(3, [EmpathySpeech("%1, the number is %2"), Text("%1, the number is %2")])
        bhv.add(3, [EmpathySpeech("%1," + Speech.markSpeech(90, 105) + "the number is %2", 50), Text("%1, the number is %2")])
        bhv.add(2, [EmpathySpeech("%1," + Speech.markSpeech(90, 120) + "the number" + Speech.markSpeech() + "is %2", 50), Text("%1, the number is %2")])
        specials[Constants.BHV_SUDOKU_REPEAT_LONG] = bhv

        bhv = ActionCollection("Can't read")
        bhv.add(0, [Speech("I barely can read."), Speech("Tell me what you wrote."), Text("I barely can read. Tell me what you wrote")])
        bhv.add(0, [Speech("I barely can read."), Speech("Can you hold it up?"), Text("I barely can read. Can you hold it up?")])
        bhv.add(0, [Speech("I can't read."), Speech("Can you tell me what you wrote?"), Text("I can't read. Can you tell me what you wrote?")])
        bhv.add(0, [Speech("I can't read."), Speech("Can you hold it up?"), Text("I can't read. Can you hold it up?")])
        bhv.add(2, [Speech("I barely can read."), Speech("Teh- teh-" + Speech.markSpeech() + "tell me what you wrote.", 90, 130), Text("I barely can read. Tell me what you wrote")])
        bhv.add(2, [Speech("I barely can read."), Speech("Can you ho- hold it up?"), Text("I barely can read. Can you hold it up?")])
        bhv.add(2, [Speech("I can't read."), Speech("Can you" + Speech.markSpeech(90, 130) + "teh- teh-" + Speech.markSpeech() + "tell me what you wrote?"), Text("I can't read. Can you tell me what you wrote?")])
        bhv.add(2, [Speech("I can't read."), Speech("Can you ho- hold it up?"), Text("I can't read. Can you hold it up?")])
        bhv.add(4, [Speech("I barely can read."), Speech(Speech.markSpeech(90, 130) + "Teh- teh- teh- teh-. Sorry. Tell me what you wrote."), Text("I barely can read. Tell me what you wrote")])
        bhv.add(4, [Speech("I barely can" + Speech.markSpeech(90, 140) + "read."), Speech("Can you hohohol- Can you hold it up?"), Text("I barely can read. Can you hold it up?")])
        bhv.add(4, [Speech("I can't read."), Speech("Can you" + Speech.markSpeech(90, 130) + "teh- teh- teh- teh-. Sorry. Tell me what you wrote?"), Text("I can't read. Can you tell me what you wrote?")])
        bhv.add(4, [Speech("I can't" + Speech.markSpeech(90, 140) + "read."), Speech("Can you hohohol- Can you hold it up?"), Text("I can't read. Can you hold it up?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "Disagree")
            bhv.add(i, None, "DisagreeLeft")
            bhv.add(i, None, "DisagreeRight")
            bhv.add(i, None, "DontKnow")
            bhv.add(i, None, "DontKnowLeft")
            bhv.add(i, None, "DontKnowRight")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointMyself")
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Which box filled?")
        bhv.add(0, [Speech("Which box did you fill?"), Text("Which box did you fill?")])
        bhv.add(0, [Speech("Where was it?"), Text("Where was it?")])
        bhv.add(2, [Speech("Which box did you fee- fill?"), Text("Which box did you fill?")])
        bhv.add(2, [Speech("Wheh- wheh- where was it?"), Text("Where was it?")])
        bhv.add(3, [Speech("Which box did you" + Speech.markSpeech(90, 130) + "fill."), Text("Which box did you fill?")])
        bhv.add(3, [Speech(Speech.markSpeech(50, 120) + "Wheh- wheh- wheh-." + Speech.markSpeech() + "I am sorry. Where was it?"), Text("Where was it?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "DontKnow")
            bhv.add(i, None, "DontKnowLeft")
            bhv.add(i, None, "DontKnowRight")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "ForgetItLeft")
            bhv.add(i, None, "ForgetItRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Fill number for me")
        bhv.add(0, [Speech("Can you fill the number in for me?"), Text("Can you fill the number in for me?")])
        bhv.add(0, [Speech("Would you fill the number in for me?"), Text("Would you fill the number in for me?")])
        bhv.add(2, [Speech("Can you fill." + Speech.markSpeech(70) + "the num- number in for me?"), Text("Can you fill the number in for me?")])
        bhv.add(2, [Speech("Would you fill." + Speech.markSpeech(70) + "the num- number in for me?"), Text("Would you fill the number in for me?")])
        bhv.add(3, [Speech("Can you fill." + Speech.markSpeech(70, 125) + "the num- number in for me?"), Text("Can you fill the number in for me?")])
        bhv.add(3, [Speech("Would you fill." + Speech.markSpeech(70, 125) + "the num- number in for me?"), Text("Would you fill the number in for me?")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
            bhv.add(i, None, "PointYou")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("My turn")
        bhv.add(0, [Speech("It's my turn."), Speech("Wait for me please."), Text("It's my turn"), Text("Wait for me please")])
        bhv.add(2, [Speech("It's my turn.", 60), Speech("Wait for me please."), Text("It's my turn"), Text("Wait for me please")])
        bhv.add(3, [Speech("It's my turn.", 60, 125), Speech("Wait for me please."), Text("It's my turn"), Text("Wait for me please")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointMyself")
            bhv.add(i, None, "PointMyselfLeft")
            bhv.add(i, None, "PointMyselfRight")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        bhv = ActionCollection("Your turn")
        bhv.add(0, [Speech("It's your turn."), Text("It's your turn")])
        bhv.add(2, [Speech("It's your turn.", 60), Text("It's your turn")])
        bhv.add(3, [Speech("It's your turn.", 60, 125), Text("It's your turn")])
        for i in range(bhv.getMaxLevel() + 1):
            bhv.add(i, None, "PointYou")
            bhv.add(i, None, "PointYouLeft")
            bhv.add(i, None, "PointYouRight")
            bhv.add(i, None, "PalmUp")
            bhv.add(i, None, "PalmUpLeft")
            bhv.add(i, None, "PalmUpRight")
        #END for
        components.append(EmpathyButton(bhv))

        return components, specials, dict()
    #END factorySudoku()
#END Empathy
