from PyQt4 import QtGui
from Action import BaseAction
from Action import Motion
from Action import Stiffness
from Nao import NaoMotion
from Nao import NaoMotionList
import random


class ActionCollection(QtGui.QPushButton):
    INDEX_ACTIONS = 0
    INDEX_MOTION = 1

    def __init__(self, name = ""):
        super(ActionCollection, self).__init__(name)
        self._name = name
        self._list = [[], []] # list of actions and motions
    #END __init__()

    def addRobotActions(self, actions = None, motions = None, insert_sequence = False):
        if actions is not None:
            if isinstance(actions, BaseAction):
                actions = [actions]
            #END if
            if len(actions) > 0:
                if insert_sequence:
                    if len(self._list[ActionCollection.INDEX_ACTIONS]) <= 0:
                        self._list[ActionCollection.INDEX_ACTIONS].append([])
                    #END if
                    self._list[ActionCollection.INDEX_ACTIONS][-1] += actions
                else:
                    self._list[ActionCollection.INDEX_ACTIONS].append(actions)
                #END if
            #END if
        #END if

        if motions is not None:
            if isinstance(motions, str):
                tmp = []
                motion = NaoMotionList.find(motions)
                if motion is not None:
                    tmp.append(Motion(motion = motion, blocking = False))
                #END if
                motions = tmp
            elif isinstance(motions, NaoMotion):
                motions = [Motion(motion = motions, blocking = False)]
            else:
                tmp = []
                for item in motions:
                    if isinstance(motions, str):
                        motion = NaoMotionList.find(item)
                        if motion is not None:
                            tmp.append(Motion(motion = motion, blocking = False))
                        #END if
                    elif isinstance(motions, NaoMotion):
                        tmp.append(Motion(motion = item, blocking = False))
                    #END if
                #END for
                motions = tmp
            #END if
            if len(motions) > 0:
                if insert_sequence:
                    if len(self._list[ActionCollection.INDEX_MOTION]) <= 0:
                        self._list[ActionCollection.INDEX_MOTION].append([])
                    #END if
                    self._list[ActionCollection.INDEX_MOTION][-1] += motions
                else:
                    self._list[ActionCollection.INDEX_MOTION].append(motions)
                #END if
            #END if
        #END if
    #END add()

    def getRobotActions(self):
        motions = []
        if len(self._list[ActionCollection.INDEX_MOTION]) > 0:
            val = random.randint(0, len(self._list[ActionCollection.INDEX_MOTION]) - 1)
            motions.append(Stiffness(1.0))
            motions += self._list[ActionCollection.INDEX_MOTION][val]
        #END if
        actions = []
        if len(self._list[ActionCollection.INDEX_ACTIONS]) > 0:
            val = random.randint(0, len(self._list[ActionCollection.INDEX_ACTIONS]) - 1)
            actions += self._list[ActionCollection.INDEX_ACTIONS][val]
        #END if
        return motions + actions
    #END get()

    def getName(self):
        return self._name
    #END getName()
#END class
