from PyQt4 import QtCore
from PyQt4 import QtGui
from Definitions import LEDNames
from Action import ActionStart
from Action import Behavior
from Action import Motion
from Action import Wait
from Action import Speech
from ActionCollection import ActionCollection
from GenderNameSpeech import GenderNameSpeech
from GenderSpeech import GenderSpeech
from UI.ActionPushButton import ActionPushButton
import random


class Gender(QtGui.QWidget):
    def __init__(self):
        super(Gender, self).__init__()
        random.seed()
        self._actionQueue = None
        self._idleCount = 0
        self._idleRun = False
        self._idleInterval = 10000
        self._idleTime = QtCore.QTime.currentTime()
        self._nao = None
        self._setupUi()
    # END __init__()

    def LEDActive(self):
        self.LEDNormal()
    # END LEDActive()

    def LEDNormal(self):
        self._nao.LEDfadeRGB(LEDNames.Face, 0x00e0ffff, 0.5, True)
        self._nao.LEDfadeRGB(LEDNames.Chest, 0x00e0ffff, 0.5, True)
        self._nao.LEDfadeRGB(LEDNames.LeftEar, 0x00ff6100, 0.5, True)
        self._nao.LEDfadeRGB(LEDNames.RightEar, 0x00ff6100, 0.5, True)
    # END LEDNormal()

    def setActionQueue(self, actionQueue):
        self._actionQueue = actionQueue
    # END setActionQueue()

    def setNao(self, nao):
        self._nao = nao
    # END setNao()

    def speech(self, txt, speed, shaping):
        return None
    # END speech()

    def hideEvent(self, event):
        self._idleRun = False
        self.killTimer(self._timerID)
    # END hideEvent()

    def showEvent(self, event):
        self._timerID = self.startTimer(50)
    # END showEvent()

    def timerEvent(self, event):
        if self._idleRun and self._idleTime < QtCore.QTime.currentTime():
            actions = self._bhvIdleSmall.get()
            actions.append(ActionStart())
            if not self._actionQueue.isRunning() and self._actionQueue.rowCount(None) <= 0:
                self._actionQueue.addActions(actions)
                self._idleCount = (self._idleCount + 1) % 5
            # END if
            self._idleTime = QtCore.QTime.currentTime().addMSecs(self._idleInterval)
        # END if
    # END timerEvent()

    def on_actionbutton_clicked(self):
        self._actionQueue.addActions(self.sender().getRobotActions())
    # END on_actionbutton_clicked()

    def on_autoidleint_valueChanged(self, value):
        self._idleInterval = value
        self._idleTime = 0
    # END on_autoidleint_valueChanged()

    def on_participantName_edited(self, value):
        GenderNameSpeech.ParticipantName = value
    # END on_participantName_edited()

    def on_toggleIdle_triggered(self):
        self._idleRun = not self._idleRun
        self._idleTime = 0
    # END on_toggleIdle_triggered()

    def _setupWidget(self, wgt, children):
        widget = QtGui.QWidget()
        layout = QtGui.QVBoxLayout(widget)
        layout.setMargin(0)
        for child in children:
            if isinstance(child, ActionCollection) or isinstance(child, ActionPushButton):
                child.clicked.connect(self.on_actionbutton_clicked)
            # END if
            layout.addWidget(child)
        # END for
        scroll = QtGui.QScrollArea()
        scroll.setAlignment(QtCore.Qt.AlignCenter)
        scroll.setWidget(widget)
        layoutScroll = QtGui.QHBoxLayout()
        layoutScroll.setMargin(0)
        layoutScroll.addWidget(scroll)
        widget = QtGui.QWidget(wgt)
        widget.setLayout(layoutScroll)
        return widget
    # END _setupWidget()

    def _setupUi(self):
        splitter = QtGui.QSplitter(self)
        splitter.setOrientation(QtCore.Qt.Horizontal)
        Gender._setupScenario(self, splitter)
        Gender._setupCommonInteractions(self, splitter)
        Gender._setupMoreTopics(self, splitter)
        Gender._setupExtraScenario(self, splitter)
        layout = QtGui.QHBoxLayout(self)
        layout.setMargin(0)
        layout.addWidget(splitter)
    # END _setupUi()

    def _setupScenario(self, wgt):
        # components = list()       
        components = []
        
        widgetName = QtGui.QWidget()
        lineeditName = QtGui.QLineEdit(widgetName)
        lineeditName.setMinimumWidth(80)
        lineeditName.textEdited.connect(lambda: self.on_participantName_edited(str(lineeditName.text())))
        layoutName = QtGui.QHBoxLayout(widgetName)
        layoutName.setMargin(0)
        layoutName.addWidget(QtGui.QLabel("Name:", widgetName))
        layoutName.addWidget(lineeditName)
        components.append(widgetName)

        components.append(QtGui.QLabel("INTRODUCTION"))

        components.append(ActionPushButton(None, "Welcome", [
                    Behavior("StandUp"),
                    Wait(200),
                    Motion("WaveHandLeft"),
                    GenderSpeech("Hi, nice to meet you."),
                    GenderSpeech("My name is Taylor."),
                    Wait(500),
                    GenderSpeech("What's your name?"),
            ]))

        components.append(ActionPushButton(None, "Nice Meet", [
                    GenderNameSpeech("Nice to meet you, " + GenderNameSpeech.NAME_MARKER),
                    Behavior("SitDown"),
                    Motion("Default"),
            ]))
        components.append(QtGui.QLabel("IDLE MOTIONS"))
        bhv = ActionCollection("move left hand figure")
        bhv.addRobotActions(None, "Idle1")
        components.append(bhv)
        
        bhv = ActionCollection("move right hand figure")
        bhv.addRobotActions(None, "Idle2")
        components.append(bhv)
        
        bhv = ActionCollection("move arm slightly")
        bhv.addRobotActions(None, "Idle3")
        components.append(bhv)      
       
        
        components.append(QtGui.QLabel("FOR STUDENT:SCHOOL & MAJOR"))
        
        bhv = ActionCollection("UofM student?")
        bhv.addRobotActions(GenderSpeech("are you a student of the University of Manitoba?")) #I deleted Hi
        bhv.addRobotActions(None, "Idle5")
        bhv.addRobotActions(None, "Idle6")
        components.append(bhv)


        bhv = ActionCollection("not um student, which school?")
        bhv.addRobotActions([Wait(1500),GenderSpeech("O, which school are you from")])
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)

        bhv = ActionCollection("what faculty")
        bhv.addRobotActions(GenderSpeech("What faculty are you in"))
#         bhv.addRobotActions(None, "PalmUpLeft")
#         bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)

        bhv = ActionCollection("what are you study")
        bhv.addRobotActions(GenderSpeech("What are you studying"))
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        bhv = ActionCollection("is that you major")
        bhv.addRobotActions(GenderSpeech("Is that your major?"))
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)

        bhv = ActionCollection("cool/interesting,tell more")
        bhv.addRobotActions(GenderSpeech("It sounds cool. Could you tell me more about it?"))
        bhv.addRobotActions(GenderSpeech("It sounds interesting. Could you tell me more about it"))
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv) 

       

        bhv = ActionCollection("like your major")
        bhv.addRobotActions(GenderSpeech("Do you like your major"))
        components.append(bhv)

        bhv = ActionCollection("like what you are working on")
        bhv.addRobotActions(GenderSpeech("Do you like what you are working on"))
        components.append(bhv)
                
        bhv = ActionCollection("why choose study this")
        bhv.addRobotActions(GenderSpeech("Why did you choose to study this"))
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        return self._setupWidget(wgt, components)
    # END _setupScenario()

    def _setupCommonInteractions(self, wgt):
        components = []
        
        components.append(QtGui.QLabel("SHORT ANSWERS"))       
       
        
        bhv = ActionCollection("Thank you/Thanks")
        bhv.addRobotActions([GenderSpeech("Thank you", speed=80)])
        bhv.addRobotActions([GenderSpeech("Thanks", speed=80)]) 
        components.append(bhv)
        
        bhv = ActionCollection("I agree/You are right")
        bhv.addRobotActions([Wait(2000), GenderSpeech("Yes, I agree.", speed=80)], "Nod1")
        bhv.addRobotActions([Wait(2500), GenderSpeech("You are right.", speed=80)], "Nod1")
        components.append(bhv)
        
        bhv = ActionCollection("Yes")
        bhv.addRobotActions([GenderSpeech("yes.", speed=80)])  
        components.append(bhv)
        
        bhv = ActionCollection("ok")
        bhv.addRobotActions([GenderSpeech("ookaee.", speed=80)])  
        components.append(bhv)  
        
        bhv = ActionCollection("nice")
        bhv.addRobotActions([GenderSpeech("nice.", speed=80)])  
        components.append(bhv)  
        
        bhv = ActionCollection("cool")
        bhv.addRobotActions([GenderSpeech("Cool.", speed=80)])  
        components.append(bhv)   
        
        bhv = ActionCollection("I am just a robot")
        bhv.addRobotActions([GenderSpeech("I am just a robot.", speed=80)])  
        components.append(bhv)   
        
#         bhv = ActionCollection("Not really")
#         bhv.addRobotActions([GenderSpeech("Not really.", speed=80)])       
#         components.append(bhv)    
#         
        
        bhv = ActionCollection("ummmh/well, let me think")
        bhv.addRobotActions([GenderSpeech("ummmh, let me think", speed=60)])
        bhv.addRobotActions([GenderSpeech("well, let me think", speed=60)])    
        components.append(bhv)
        
        bhv = ActionCollection("I see/I got you")
        bhv.addRobotActions([Wait(2500), GenderSpeech("I see", speed=60)], "Nod1")
        bhv.addRobotActions([Wait(2500), GenderSpeech("I got you.", speed=80)], "Nod1")
        components.append(bhv)

        bhv = ActionCollection("You are welcome/welcome")
        bhv.addRobotActions([GenderSpeech("You are welcome.", speed=80)])  
        bhv.addRobotActions(GenderSpeech("Welcome."))
        components.append(bhv)
        
        bhv = ActionCollection("Speak louder")
        bhv.addRobotActions([GenderSpeech("Could you speak bit louder?")])
        bhv.addRobotActions(None, "Idle5")
        bhv.addRobotActions(None, "Idle6") 
        components.append(bhv)       

        bhv = ActionCollection("can we talk about something else")
        bhv.addRobotActions(GenderSpeech("can we please talk about something else?"))
        bhv.addRobotActions(None, "Idle5")
        bhv.addRobotActions(None, "Idle6")
        components.append(bhv)
  
        bhv = ActionCollection("would you like to ask me something")
        bhv.addRobotActions(GenderSpeech("would you like to ask me something?"))
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        bhv = ActionCollection("I don't understand, talk other things")
        bhv.addRobotActions(GenderSpeech("I am sorry I don't understand. Why don't we talk about something else?"))
        components.append(bhv)
             
        bhv = ActionCollection("I don't understand your question")
        bhv.addRobotActions(GenderSpeech("I don't understand your question."))
        components.append(bhv)
        
        bhv = ActionCollection("Oops! I made a mistake")
        bhv.addRobotActions(GenderSpeech("Oops! I made a mistake."))
        components.append(bhv)
      
        return self._setupWidget(wgt, components)
    # END _setupEmotionalInteractions()

    # To do: switch personality & ending conversation
    def _setupMoreTopics(self, wgt): 
        components = []
 
#         #add two vertical widgets for high vs. low confidence cases(Don't know how to add components to subwidgets, finish UI first, try later)
#         splitter = QtGui.QSplitter(wgt)
#         splitter.setOrientation(QtCore.Qt.Vertical)
#  
#         #widget for low confidence
#         wgtLowConfidence = QtGui.QWidget(splitter)
#         layoutLowConfidence = QtGui.QVBoxLayout(wgtLowConfidence)
#         layoutLowConfidence.setMargin(0)
#           
#         
#         button = QtGui.QPushButton("TESTING A", wgtLowConfidence)
#         layoutLowConfidence.addWidget(button)     
#                 
#         scroll = QtGui.QScrollArea()
#         scroll.setAlignment(QtCore.Qt.AlignCenter)
#         scroll.setWidget(wgtLowConfidence)
#         layoutScroll = QtGui.QVBoxLayout()
#         layoutScroll.setMargin(0)
#         layoutScroll.addWidget(scroll)
#         
#         
#         #widget for high confidence
#         widget = QtGui.QWidget(splitter)
#         layout = QtGui.QVBoxLayout(widget)
#         layout.setMargin(0)
#         layout.addLayout(layoutScroll)
#  
#         wgtHighConfidence = QtGui.QWidget()
#         layoutHighConfidence = QtGui.QVBoxLayout(wgtHighConfidence)
#         layoutHighConfidence.setMargin(0)
# 
#         button = QtGui.QPushButton("TESTING B", wgtHighConfidence)
#         layoutHighConfidence.addWidget(button)
#  
#  
#         scroll = QtGui.QScrollArea()
#         scroll.setAlignment(QtCore.Qt.AlignCenter)
#         scroll.setWidget(wgtHighConfidence)
#         layoutScroll = QtGui.QVBoxLayout()
#         layoutScroll.setMargin(0)
#         layoutScroll.addWidget(scroll)
#   
#         widget = QtGui.QWidget(splitter)
#         layout = QtGui.QVBoxLayout(widget)
#         layout.setMargin(0)
#         layout.addLayout(layoutScroll)        
        components.append(QtGui.QLabel("Previous exprience with a robot")) 
        
        bhv = ActionCollection("have previous experience")
        bhv.addRobotActions([GenderSpeech("Have you interacted with a robot before?")])
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        bhv = ActionCollection("if no, glad it's the first talk")
        bhv.addRobotActions([GenderSpeech("I am glad that I am the first robot talking with you.")])
        components.append(bhv)
        
        bhv = ActionCollection("if yes, like interacting with us")
        bhv.addRobotActions([GenderSpeech("Nice, do you like interacting with us?")])
        bhv.addRobotActions(None, "PalmUp")
        components.append(bhv)
       
        bhv = ActionCollection("if like, Glad to here that")
        bhv.addRobotActions([GenderSpeech("I am glad to hear thaat.")])
        components.append(bhv)
        
        bhv = ActionCollection("if dislike, why")
        bhv.addRobotActions([GenderSpeech("O, could you tell me why?")])
        components.append(bhv)
        
        bhv = ActionCollection("answer after why")
        bhv.addRobotActions([GenderSpeech("ookaee. That makes sense.")])
        components.append(bhv)
        
        components.append(QtGui.QLabel("HOBBY"))
        
        bhv = ActionCollection("What to do in spare time")
        bhv.addRobotActions([GenderSpeech("what do you do in your spare time", 80)])
        
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        bhv = ActionCollection("fun, is that your hobby")
        bhv.addRobotActions([GenderSpeech("It sounds fun. is that your hobby?")])
        components.append(bhv)
        
        bhv = ActionCollection("Do you have any other hobby")
        bhv.addRobotActions(GenderSpeech("Do you have any other hobby?"))
        components.append(bhv)
        
        bhv = ActionCollection("what are your hobbies?")
        bhv.addRobotActions(GenderSpeech("What are your hobbies"))
        components.append(bhv)
        
        components.append(QtGui.QLabel("MOVIE"))
        
        bhv = ActionCollection("like movie?")
        bhv.addRobotActions([GenderSpeech("Do you like watching movies?", 80)])        
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        bhv = ActionCollection("What kind of movie you like")
        bhv.addRobotActions([GenderSpeech("What kind of movies do you like")])
        components.append(bhv)
        
        bhv = ActionCollection("favorite movie")
        bhv.addRobotActions(GenderSpeech("Can you please tell me what is your favorite movie?"))
        components.append(bhv)
        
        bhv = ActionCollection("why?")
        bhv.addRobotActions(GenderSpeech("Nice. Why do you like that movie"))
        components.append(bhv)
                
        return self._setupWidget(wgt, components)
    # END _setupBehaviours()

    def _setupExtraScenario(self, wgt):
        components = []
        
        components.append(QtGui.QLabel("PART TIME JOB"))    
        
        bhv = ActionCollection("have a part time job?")
        bhv.addRobotActions(GenderSpeech("Do you have a part time job?"))
        bhv.addRobotActions(None, "Idle5")
        bhv.addRobotActions(None, "Idle6")
        components.append(bhv)
        
        bhv = ActionCollection("what do you do there")
        bhv.addRobotActions(GenderSpeech("what do you do there"))
        components.append(bhv)
        
        bhv = ActionCollection("do you like your job")
        bhv.addRobotActions(GenderSpeech("do you like your job?"))
        bhv.addRobotActions(None, "Idle5")
        bhv.addRobotActions(None, "Idle6")
        components.append(bhv)
        
        bhv = ActionCollection("why like your job")
        bhv.addRobotActions(GenderSpeech("Why do you like your job"))
        bhv.addRobotActions(None, "Idle5")
        bhv.addRobotActions(None, "Idle6")
        components.append(bhv)
        
        bhv = ActionCollection("what kind of jobs do you like")
        bhv.addRobotActions(GenderSpeech("What kind of jobs do you like"))
        bhv.addRobotActions(None, "Idle5")
        bhv.addRobotActions(None, "Idle6")
        components.append(bhv)
        
        bhv = ActionCollection("no job, plan to get a job in the future?")
        bhv.addRobotActions(GenderSpeech("ookaee. Are you planning to get a part time job in the future?"))
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        bhv = ActionCollection("future job, what kind of job")
        bhv.addRobotActions(GenderSpeech("Good. What kind of job are you going to do"))
#         bhv.addRobotActions(None, "PalmUpLeft")
#         bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        
        bhv = ActionCollection("ok, Let's talk something else")
        bhv.addRobotActions(GenderSpeech("ookaee. Let's talk about something else?"))
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        components.append(QtGui.QLabel("End Conversation"))   
        
        bhv = ActionCollection("Thank you for sharing")
        bhv.addRobotActions(GenderSpeech("Thank you for sharing this with me."))
        bhv.addRobotActions(None, "PalmUpLeft")
        bhv.addRobotActions(None, "PalmUpRight")
        components.append(bhv)
        
        bhv = ActionCollection("Nice talking to you")
        bhv.addRobotActions([GenderSpeech("Nice talking to you.")])
        components.append(bhv)
 
       
      
        return self._setupWidget(wgt, components)
    # END _setupRationalInteractions()
